% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_inset.R
\name{tm_inset}
\alias{tm_inset}
\title{Map component: inset maps and other objects}
\usage{
tm_inset(
  x = NULL,
  height,
  width,
  margins,
  between_margin,
  position,
  group_id,
  frame,
  frame.color,
  frame.alpha,
  frame.lwd,
  frame.r,
  bg,
  bg.color,
  bg.alpha,
  z
)
}
\arguments{
\item{x}{object to draw. Can be: bounding box, tmap object, ggplot2 object, grob object, image file name.}

\item{height}{height of the component in number of text line heights.}

\item{width}{width of the component in number of text line heights.}

\item{margins}{margins}

\item{between_margin}{Margin between}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{frame}{frame should a frame be drawn?}

\item{frame.color}{frame color}

\item{frame.alpha}{frame alpha transparancy}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg}{Show background?}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{z}{z index, e.g. the place of the component relative to the other componets}
}
\description{
Map component that adds an inset object, e.g. a mini map
}
\examples{
## map
bb = tmaptools::bb(NLD_prov[NLD_prov$name == "Utrecht",], ext = 1.05)

bb_Randstad =
  sf::st_bbox(c(xmin = 120000, xmax = 150000, ymin = 460000, ymax = 500000), crs = 28992)

tm_shape(NLD_dist) +
	tm_polygons(
		fill = "dwelling_value",
		fill.scale = tm_scale_continuous_pseudo_log(values = "-cols4all.pu_gn_div"),
		col = NULL) +
tm_shape(NLD_muni) +
	tm_borders(col = "black", lwd = 0.5) +
tm_shape(NLD_prov) +
	tm_borders(col = "black", lwd = 1.5) +
tm_inset(bb_Randstad, height = 12, width = 12, position = c("left", "top")) +
	tm_compass(position = c("left", "top"), )

## ggplot2
if (requireNamespace("ggplot2")) {
	library(ggplot2)
	p = ggplot(World, aes(x = gender, y = press, colour = continent)) +
		geom_point() +
		theme_bw()

	tm_shape(World) +
		tm_polygons(
			fill = "gender",
			fill.scale = tm_scale(values = "-cols4all.pu_gn_div")) +
		tm_inset(p, height = 15, width = 20, position = tm_pos_in("left", "bottom"))
}
}
