% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_shape.R
\name{crop_shape}
\alias{crop_shape}
\title{Crop shape object}
\usage{
crop_shape(x, y, polygon = FALSE, ...)
}
\arguments{
\item{x}{shape object, i.e. an object from class \code{\link[sp:Spatial]{Spatial-class}}, \code{\link[raster:Raster-class]{Raster}}, or \code{sf}.}

\item{y}{bounding box (2 by 2 matrix), an \code{\link[raster:extent]{extent}}, or a shape object from which the bounding box is extracted (unless \code{polygon} is \code{TRUE} and \code{x} is a \code{SpatialPolygons} object).}

\item{polygon}{should \code{x} be cropped by the polygon defined by \code{y}? If \code{FALSE} (default), \code{x} is cropped by the bounding box of \code{x}. Polygon cropping only works when \code{x} is a spatial object and \code{y} is a \code{SpatialPolygons} object.}

\item{...}{arguments passed on to \code{\link[raster:crop]{crop}}}
}
\value{
cropped shape, in the same class as \code{x}
}
\description{
Crop a shape object (from class \code{\link[sp:Spatial]{Spatial}}, \code{\link[raster:Raster-class]{Raster}}, or \code{sf}). A shape file \code{x} is cropped, either by the bounding box of another shape \code{y}, or by \code{y} itself if it is a SpatialPolygons object and \code{polygon = TRUE}.
}
\details{
This function is similar to \code{\link[raster:crop]{crop}} from the \code{raster} package. The main difference is that \code{crop_shape} also allows to crop using a polygon instead of a rectangle.
}
\examples{
if (require(tmap)) {
    data(Europe, land, metro)

    land_europe <- crop_shape(land, Europe)

    qtm(land_europe, raster="trees", style="natural")

    metro_europe <- crop_shape(metro, Europe, polygon = TRUE)

    qtm(Europe) +
    tm_shape(metro_europe) +
    	tm_bubbles("pop2010", col="red", title.size="European cities") +
    	tm_legend(frame=TRUE)
}
}
\seealso{
\code{\link{bb}}
}

