% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modstats.R
\name{getGenes}
\alias{getGenes}
\title{Get genes belonging to a gene set}
\usage{
getGenes(gs = NULL, genes = NULL, fg = NULL, mset = "all", as.list = FALSE)
}
\arguments{
\item{gs}{gene set IDs; if NULL, returns all genes from all gene sets}

\item{genes}{character vector with gene IDs. If not NULL, only genes
from this parameter will be considered.}

\item{fg}{genes which are in the foreground set}

\item{mset}{gene set to use (default: all tmod gene sets)}

\item{as.list}{should a list of genes rather than a data frame be returned}
}
\value{
data frame containing module to gene mapping, or a list (if
as.list == TRUE
}
\description{
Get genes belonging to a gene set
}
\details{
Create a data frame mapping each module to a comma separated list of
genes. If genelist is provided, then only genes in that list will be
shown. An optional column, "fg" informs which genes are in the "foreground"
data set.
}
