% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pane.R, R/window.R
\name{new_pane}
\alias{new_pane}
\alias{split_window}
\title{Create a new tmux pane}
\usage{
new_pane(
  target = NULL,
  vertical = TRUE,
  size = NULL,
  before = FALSE,
  full = FALSE,
  start_directory = NULL,
  shell_command = NULL
)

split_window(
  target = NULL,
  vertical = TRUE,
  size = NULL,
  before = FALSE,
  full = FALSE,
  start_directory = NULL,
  shell_command = NULL
)
}
\arguments{
\item{target}{A tmuxr_session, tmuxr_window, or tmuxr_pane.}

\item{vertical}{A logical. If \code{TRUE} split \code{target} vertically, otherwise
horizontally. Default: \code{TRUE}.}

\item{size}{A numeric. The size of the new pane in lines (for vertical
splits) or characters (for horizontal splits). If less than \code{0}, \code{size} is
interpreted as a percentage. Default: \code{NULL}.}

\item{before}{A logical. If \code{TRUE}, create the new pane to the left of or
above the active pane. Default: \code{FALSE}.}

\item{full}{A logical. If \code{TRUE}, create a new pane spanning the full window
width (for vertical splits) or full window height (for horizontal splits),
instead of splitting the active pane. Default: \code{FALSE}.}

\item{start_directory}{A string. Working directory this pane is run in.}

\item{shell_command}{A string. Shell command to be invoked when creating the
pane. If \code{NULL}, the default shell is used.}
}
\value{
A tmuxr_pane.
}
\description{
Create a new pane by splitting \code{target}.
}
