% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorize.R
\name{factorize_df}
\alias{factorize_df}
\title{Convert all character vectors containing a set of values in a data.frame to factors.}
\usage{
factorize_df(dat, lvls, ignore.case = NULL)
}
\arguments{
\item{dat}{data.frame with some factor variables stored as characters.}

\item{lvls}{The factor levels in your variable(s), in order.  If you have a question whose possible responses are a subset of another question's, don't use this function; manipulate the specific columns with \code{dplyr::mutate_at}.}

\item{ignore.case}{Logical. If TRUE, will match without checking case, using the capitalization from the \code{lvls} parameter for the final output. If not provided, the function will provide a warning if it detects columns that would match without checking case but will NOT coerce them.}
}
\value{
a data.frame the same size as \code{dat}, with factorization completed in place.
}
\description{
This function examines each column in a data.frame; when it finds a column composed solely of the values provided to the \code{lvls} argument it updates them to be factor variables, with levels in the order provided.

This is an alternative to calling \code{dplyr::mutate_at} with \code{factor()} and identifying the specific variables you want to transform, if you have several repeated sets of responses.
}
\examples{
teacher_survey |>
  factorize_df(lvls = c("Strongly Disagree", "Disagree", "Somewhat Disagree",
                        "Somewhat Agree", "Agree", "Strongly Agree"))

# prints warning due to case mismatches:
teacher_survey |>
  factorize_df(lvls = c("Strongly disagree", "Disagree", "Somewhat disagree",
                        "Somewhat agree", "Agree", "Strongly agree"))
}
