% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_tntp.R
\name{palette_tntp}
\alias{palette_tntp}
\title{TNTP branded color palettes}
\usage{
palette_tntp(...)
}
\arguments{
\item{...}{supply quoted color names to include in color palette}
}
\value{
a character vector
}
\description{
This function as been superseded by \code{\link[=tntp_colors]{tntp_colors()}} which has improved
functionality and includes the most recent TNTP brand colors.

This function creates user defined color palette combinations for up to
eleven colors. There are nine TNTP approved colors: dark_blue, medium_blue,
light_blue, green, orange, gold, dark_grey (dark_gray), medium_grey
(medium_gray), light_grey (light_gray). White and black are also available.
}
\examples{
library(ggplot2)

pal1_tntp <- tntp_colors("green", "gold", "orange")
pal2_tntp <- tntp_colors("navy", "cerulean", "sky")

p <- ggplot(mtcars, aes(wt, mpg))
p <- p + geom_point(aes(colour = factor(cyl)))
p

# Change colors to created palette
p <- p + scale_color_manual(values = pal1_tntp)
p

g <- ggplot(mtcars, aes(factor(cyl), mean(mpg)))
g <- g + geom_bar(aes(fill = factor(cyl)), stat = "identity")
g

# Change fill to created palette
g <- g + scale_fill_manual(values = pal2_tntp)
g
}
