% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingKmeans.R
\name{createSilhouetteProfile}
\alias{createSilhouetteProfile}
\title{Create cluster silhouette profile plot.}
\usage{
createSilhouetteProfile(km, baseSize = 12, baseFamily = "serif",
  title = "Cluster Silhouette Profile (Histogram)",
  xlab = "Silhouette Value", ylab = "Count", coordFlip = TRUE,
  ticks = FALSE, defaultTheme = theme_tufte(base_size = baseSize,
  base_family = baseFamily, ticks = ticks), themeExtra = NULL)
}
\arguments{
\item{km}{an object of class \code{"toakmeans"} returned by \code{\link{computeKmeans}}.}

\item{baseSize}{\code{\link{theme}} base font size.}

\item{baseFamily}{\code{\link{theme}} base font family.}

\item{title}{plot title.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{coordFlip}{logical flipped cartesian coordinates so that horizontal becomes vertical, and vertical horizontal (see 
\link{coord_flip}).}

\item{ticks}{\code{logical} Show axis ticks using default theme settings (see \code{defaultTheme})?}

\item{defaultTheme}{plot theme settings with default value \code{\link[ggthemes]{theme_tufte}}. More themes
are available here: \code{\link[ggplot2]{ggtheme}} (by \href{http://ggplot2.org/}{ggplot2}) 
and \code{\link[ggthemes]{ggthemes}}.}

\item{themeExtra}{any additional \code{\link[ggplot2]{theme}} settings that override default theme.}
}
\value{
ggplot object
}
\description{
Create cluster silhouette profile plot.
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
km = computeKmeans(conn, "batting", centers=5, iterMax = 25,
                   aggregates = c("COUNT(*) cnt", "AVG(g) avg_g", "AVG(r) avg_r", "AVG(h) avg_h"),
                   id="playerid || '-' || stint || '-' || teamid || '-' || yearid", 
                   include=c('g','r','h'), scaledTableName='kmeans_test_scaled', 
                   centroidTableName='kmeans_test_centroids',
                   where="yearid > 2000")
km = computeSilhouette(conn, km)
createSilhouetteProfile(km, title="Cluster Silhouette Histograms (Profiles)")
}
}

