% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizer.R
\name{tokenizer}
\alias{tokenizer}
\title{Tokenizer}
\value{
A tokenizer that can be used for encoding character strings or decoding
integers.
}
\description{
A Tokenizer works as a pipeline. It processes some raw text as input and outputs
an \link{encoding}.
}
\examples{
withr::with_envvar(c(HUGGINGFACE_HUB_CACHE = tempdir()), {
try({
tok <- tokenizer$from_pretrained("gpt2")
tok$encode("Hello world")$ids
})
})

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.tokenizer}}{(unsafe usage) Lower level pointer to tokenizer}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-tok_tokenizer-new}{\code{tokenizer$new()}}
\item \href{#method-tok_tokenizer-encode}{\code{tokenizer$encode()}}
\item \href{#method-tok_tokenizer-decode}{\code{tokenizer$decode()}}
\item \href{#method-tok_tokenizer-encode_batch}{\code{tokenizer$encode_batch()}}
\item \href{#method-tok_tokenizer-decode_batch}{\code{tokenizer$decode_batch()}}
\item \href{#method-tok_tokenizer-from_file}{\code{tokenizer$from_file()}}
\item \href{#method-tok_tokenizer-from_pretrained}{\code{tokenizer$from_pretrained()}}
\item \href{#method-tok_tokenizer-clone}{\code{tokenizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-new}{}}}
\subsection{Method \code{new()}}{
Initializes a tokenizer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$new(tokenizer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tokenizer}}{Will be cloned to initialize a new tokenizer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-encode"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-encode}{}}}
\subsection{Method \code{encode()}}{
Encode the given sequence and pair. This method can process raw text sequences
as well as already pre-tokenized sequences.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$encode(
  sequence,
  pair = NULL,
  is_pretokenized = FALSE,
  add_special_tokens = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sequence}}{The main input sequence we want to encode. This sequence can
be either raw text or pre-tokenized, according to the is_pretokenized argument}

\item{\code{pair}}{An optional input sequence. The expected format is the same
that for sequence.}

\item{\code{is_pretokenized}}{Whether the input is already pre-tokenized}

\item{\code{add_special_tokens}}{Whether to add the special tokens}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-decode"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-decode}{}}}
\subsection{Method \code{decode()}}{
Decode the given list of ids back to a string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$decode(ids, skip_special_tokens = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{The list of ids that we want to decode}

\item{\code{skip_special_tokens}}{Whether the special tokens should be removed from the decoded string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-encode_batch"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-encode_batch}{}}}
\subsection{Method \code{encode_batch()}}{
Encodes a batch of sequences. Returns a list of \link{encoding}s.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$encode_batch(
  input,
  is_pretokenized = FALSE,
  add_special_tokens = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{A list of single sequences or pair sequences to encode. Each
sequence can be either raw text or pre-tokenized, according to the is_pretokenized
argument.}

\item{\code{is_pretokenized}}{Whether the input is already pre-tokenized}

\item{\code{add_special_tokens}}{Whether to add the special tokens}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-decode_batch"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-decode_batch}{}}}
\subsection{Method \code{decode_batch()}}{
Decode a batch of ids back to their corresponding string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$decode_batch(sequences, skip_special_tokens = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sequences}}{The batch of sequences we want to decode}

\item{\code{skip_special_tokens}}{Whether the special tokens should be removed from the decoded strings}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-from_file"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-from_file}{}}}
\subsection{Method \code{from_file()}}{
Creates a tokenizer from the path of a serialized tokenizer.
This is a static method and should be called instead of \verb{$new} when initializing
the tokenizer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$from_file(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to tokenizer.json file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-from_pretrained"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-from_pretrained}{}}}
\subsection{Method \code{from_pretrained()}}{
Instantiate a new Tokenizer from an existing file on the Hugging Face Hub.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$from_pretrained(identifier, revision = "main", auth_token = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{The identifier of a Model on the Hugging Face Hub, that
contains a tokenizer.json file}

\item{\code{revision}}{A branch or commit id}

\item{\code{auth_token}}{An optional auth token used to access private repositories
on the Hugging Face Hub}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tok_tokenizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-tok_tokenizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tokenizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
