% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_sort}
\alias{torch_sort}
\title{Sort}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int, optional) the dimension to sort along}

\item{descending}{(bool, optional) controls the sorting order (ascending or descending)}

\item{out}{(tuple, optional) the output tuple of (\code{Tensor}, \code{LongTensor}) that can        be optionally given to be used as output buffers}
}
\description{
Sort
}
\section{sort(input, dim=-1, descending=False, out=None) -> (Tensor, LongTensor) }{


Sorts the elements of the \code{input} tensor along a given dimension
in ascending order by value.

If \code{dim} is not given, the last dimension of the \code{input} is chosen.

If \code{descending} is \code{True} then the elements are sorted in descending
order by value.

A namedtuple of (values, indices) is returned, where the \code{values} are the
sorted values and \code{indices} are the indices of the elements in the original
\code{input} tensor.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 4))
out = torch_sort(x)
out
out = torch_sort(x, 1)
out
}
}
