% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_polygamma}
\alias{torch_polygamma}
\title{Polygamma}
\usage{
torch_polygamma(n, self)
}
\arguments{
\item{n}{(int) the order of the polygamma function}

\item{self}{(Tensor) the input tensor.}
}
\description{
Polygamma
}
\note{
\preformatted{This function is not implemented for \eqn{n \geq 2}.
}
}
\section{polygamma(n, input, out=NULL) -> Tensor }{


Computes the \eqn{n^{th}} derivative of the digamma function on \code{input}.
\eqn{n \geq 0} is called the order of the polygamma function.

\deqn{
    \psi^{(n)}(x) = \frac{d^{(n)}}{dx^{(n)}} \psi(x)
}
}

\examples{
if (torch_is_installed()) {
\dontrun{
a = torch_tensor(c(1, 0.5))
torch_polygamma(1, a)
}
}
}
