% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_glu}
\alias{nnf_glu}
\title{Glu}
\usage{
nnf_glu(input, dim = -1)
}
\arguments{
\item{input}{(Tensor) input tensor}

\item{dim}{(int) dimension on which to split the input. Default: -1}
}
\description{
The gated linear unit. Computes:
}
\details{
\deqn{GLU(a, b) = a \otimes \sigma(b)}

where \code{input} is split in half along \code{dim} to form \code{a} and \code{b}, \eqn{\sigma}
is the sigmoid function and \eqn{\otimes} is the element-wise product
between matrices.

See \href{https://arxiv.org/abs/1612.08083}{Language Modeling with Gated Convolutional Networks}.
}
