% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-utils-rnn.R
\name{nn_utils_rnn_pad_sequence}
\alias{nn_utils_rnn_pad_sequence}
\title{Pad a list of variable length Tensors with \code{padding_value}}
\usage{
nn_utils_rnn_pad_sequence(sequences, batch_first = FALSE, padding_value = 0)
}
\arguments{
\item{sequences}{\code{(list[Tensor])}: list of variable length sequences.}

\item{batch_first}{(bool, optional): output will be in \verb{B x T x *} if \code{TRUE},
or in \verb{T x B x *} otherwise}

\item{padding_value}{(float, optional): value for padded elements. Default: 0.}
}
\value{
Tensor of size \verb{T x B x *} if \code{batch_first} is \code{FALSE}.
Tensor of size \verb{B x T x *} otherwise
}
\description{
\code{pad_sequence} stacks a list of Tensors along a new dimension,
and pads them to equal length. For example, if the input is list of
sequences with size \verb{L x *} and if batch_first is False, and \verb{T x B x *}
otherwise.
}
\details{
\code{B} is batch size. It is equal to the number of elements in \code{sequences}.
\code{T} is length of the longest sequence.
\code{L} is length of the sequence.
\code{*} is any number of trailing dimensions, including none.
}
\note{
This function returns a Tensor of size \verb{T x B x *} or \verb{B x T x *}
where \code{T} is the length of the longest sequence. This function assumes
trailing dimensions and type of all the Tensors in sequences are same.
}
\examples{
if (torch_is_installed()) {
a <- torch_ones(25, 300)
b <- torch_ones(22, 300)
c <- torch_ones(15, 300)
nn_utils_rnn_pad_sequence(list(a, b, c))$size()
}
}
