% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-embedding.R
\name{nnf_embedding}
\alias{nnf_embedding}
\title{Embedding}
\usage{
nnf_embedding(
  input,
  weight,
  padding_idx = NULL,
  max_norm = NULL,
  norm_type = 2,
  scale_grad_by_freq = FALSE,
  sparse = FALSE
)
}
\arguments{
\item{input}{(LongTensor) Tensor containing indices into the embedding matrix}

\item{weight}{(Tensor) The embedding matrix with number of rows equal to the
maximum possible index + 1, and number of columns equal to the embedding size}

\item{padding_idx}{(int, optional) If given, pads the output with the embedding
vector at \code{padding_idx} (initialized to zeros) whenever it encounters the index.}

\item{max_norm}{(float, optional) If given, each embedding vector with norm larger
than \code{max_norm} is renormalized to have norm \code{max_norm}. Note: this will modify
\code{weight} in-place.}

\item{norm_type}{(float, optional) The p of the p-norm to compute for the \code{max_norm}
option. Default \code{2}.}

\item{scale_grad_by_freq}{(boolean, optional) If given, this will scale gradients
by the inverse of frequency of the words in the mini-batch. Default \code{FALSE}.}

\item{sparse}{(bool, optional) If \code{TRUE}, gradient w.r.t. \code{weight} will be a
sparse tensor. See Notes under \code{nn_embedding} for more details regarding
sparse gradients.}
}
\description{
A simple lookup table that looks up embeddings in a fixed dictionary and size.
}
\details{
This module is often used to retrieve word embeddings using indices.
The input to the module is a list of indices, and the embedding matrix,
and the output is the corresponding word embeddings.
}
