% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_solve}
\alias{linalg_solve}
\title{Computes the solution of a square system of linear equations with a unique solution.}
\usage{
linalg_solve(A, B)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions.}

\item{B}{(Tensor): right-hand side tensor of shape \verb{(*, n)} or  \verb{(*, n, k)} or \verb{(n,)} or \verb{(n, k)}
according to the rules described above}
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
this function computes the solution \teqn{X \in \mathbb{K}^{n \times k}} of the \strong{linear system} associated to
\teqn{A \in \mathbb{K}^{n \times n}, B \in \mathbb{K}^{m \times k}}, which is defined as
}
\details{
\deqn{
  AX = B
}

This system of linear equations has one solution if and only if \teqn{A} is \code{invertible}_.
This function assumes that \teqn{A} is invertible.
Supports inputs of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if the inputs are batches of matrices then
the output has the same batch dimensions.

Letting \code{*} be zero or more batch dimensions,
\itemize{
\item If \code{A} has shape \verb{(*, n, n)} and \code{B} has shape \verb{(*, n)} (a batch of vectors) or shape
\verb{(*, n, k)} (a batch of matrices or "multiple right-hand sides"), this function returns \code{X} of shape
\verb{(*, n)} or \verb{(*, n, k)} respectively.
\item Otherwise, if \code{A} has shape \verb{(*, n, n)} and  \code{B} has shape \verb{(n,)}  or \verb{(n, k)}, \code{B}
is broadcasted to have shape \verb{(*, n)} or \verb{(*, n, k)} respectively.
}

This function then returns the solution of the resulting batch of systems of linear equations.
}
\note{
This function computes \code{X = A$inverse() @ B} in a faster and
more numerically stable way than performing the computations separately.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(3, 3)
b <- torch_randn(3)
x <- linalg_solve(A, b)
torch_allclose(torch_matmul(A, x), b)
}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky}()},
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
