% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_multinomial}
\alias{torch_multinomial}
\title{Multinomial}
\usage{
torch_multinomial(self, num_samples, replacement = FALSE, generator = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor containing probabilities}

\item{num_samples}{(int) number of samples to draw}

\item{replacement}{(bool, optional) whether to draw with replacement or not}

\item{generator}{(\code{torch.Generator}, optional) a pseudorandom number generator for sampling}
}
\description{
Multinomial
}
\note{
\preformatted{The rows of `input` do not need to sum to one (in which case we use
the values as weights), but must be non-negative, finite and have
a non-zero sum.
}

Indices are ordered from left to right according to when each was sampled
(first samples are placed in first column).

If \code{input} is a vector, \code{out} is a vector of size \code{num_samples}.

If \code{input} is a matrix with \code{m} rows, \code{out} is an matrix of shape
\eqn{(m \times \mbox{num\_samples})}.

If replacement is \code{TRUE}, samples are drawn with replacement.

If not, they are drawn without replacement, which means that when a
sample index is drawn for a row, it cannot be drawn again for that row.

\preformatted{When drawn without replacement, `num_samples` must be lower than
number of non-zero elements in `input` (or the min number of non-zero
elements in each row of `input` if it is a matrix).
}
}
\section{multinomial(input, num_samples, replacement=False, *, generator=NULL, out=NULL) -> LongTensor }{


Returns a tensor where each row contains \code{num_samples} indices sampled
from the multinomial probability distribution located in the corresponding row
of tensor \code{input}.
}

\examples{
if (torch_is_installed()) {

weights = torch_tensor(c(0, 10, 3, 0), dtype=torch_float()) # create a tensor of weights
torch_multinomial(weights, 2)
torch_multinomial(weights, 4, replacement=TRUE)
}
}
