% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_trunc_normal_}
\alias{nn_init_trunc_normal_}
\title{Truncated normal initialization}
\usage{
nn_init_trunc_normal_(tensor, mean = 0, std = 1, a = -2, b = 2)
}
\arguments{
\item{tensor}{an n-dimensional Tensor}

\item{mean}{the mean of the normal distribution}

\item{std}{the standard deviation of the normal distribution}

\item{a}{the minimum cutoff value}

\item{b}{the maximum cutoff value}
}
\description{
Fills the input Tensor with values drawn from a truncated
normal distribution.
}
\examples{
if (torch_is_installed()) {
w <- torch_empty(3, 5)
nn_init_trunc_normal_(w)

}
}
