% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_transpose}
\alias{torch_transpose}
\title{Transpose}
\usage{
torch_transpose(self, dim0, dim1)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim0}{(int) the first dimension to be transposed}

\item{dim1}{(int) the second dimension to be transposed}
}
\description{
Transpose
}
\section{transpose(input, dim0, dim1) -> Tensor }{


Returns a tensor that is a transposed version of \code{input}.
The given dimensions \code{dim0} and \code{dim1} are swapped.

The resulting \code{out} tensor shares it's underlying storage with the
\code{input} tensor, so changing the content of one would change the content
of the other.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(2, 3))
x
torch_transpose(x, 1, 2)
}
}
