% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_compute_deltas}
\alias{functional_compute_deltas}
\title{Delta Coefficients (functional)}
\usage{
functional_compute_deltas(specgram, win_length = 5, mode = "replicate")
}
\arguments{
\item{specgram}{(Tensor): Tensor of audio of dimension (..., freq, time)}

\item{win_length}{(int, optional): The window length used for computing delta (Default: \code{5})}

\item{mode}{(str, optional): Mode parameter passed to padding (Default: \code{"replicate"})}
}
\value{
\code{tensor}: Tensor of deltas of dimension (..., freq, time)
}
\description{
Compute delta coefficients of a tensor, usually a spectrogram.
}
\details{
math:
\deqn{d_t = \frac{\sum_{n=1}^{N} n  (c_{t+n} - c_{t-n})}{2 \sum_{n=1}^{N} n^2}}

where \code{d_t} is the deltas at time \code{t}, \code{c_t} is the spectrogram coeffcients at time \code{t},
\code{N} is \code{ (win_length-1) \%/\% 2}.
}
\examples{
if(torch::torch_is_installed()) {
library(torch)
library(torchaudio)
specgram = torch_randn(1, 40, 1000)
delta = functional_compute_deltas(specgram)
delta2 = functional_compute_deltas(delta)
}

}
