% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tranforms.R
\name{transform_inverse_mel_scale}
\alias{transform_inverse_mel_scale}
\title{Inverse Mel Scale}
\usage{
transform_inverse_mel_scale(
  n_stft,
  n_mels = 128,
  sample_rate = 16000,
  f_min = 0,
  f_max = NULL,
  max_iter = 1e+05,
  tolerance_loss = 1e-05,
  tolerance_change = 1e-08,
  ...
)
}
\arguments{
\item{n_stft}{(int): Number of bins in STFT. See \code{n_fft} in \link{transform_spectrogram}.}

\item{n_mels}{(int, optional): Number of mel filterbanks. (Default: \code{128})}

\item{sample_rate}{(int, optional): Sample rate of audio signal. (Default: \code{16000})}

\item{f_min}{(float, optional): Minimum frequency. (Default: \code{0.})}

\item{f_max}{(float or NULL, optional): Maximum frequency. (Default: \code{sample_rate \%/\% 2})}

\item{max_iter}{(int, optional): Maximum number of optimization iterations. (Default: \code{100000})}

\item{tolerance_loss}{(float, optional): Value of loss to stop optimization at. (Default: \code{1e-5})}

\item{tolerance_change}{(float, optional): Difference in losses to stop optimization at. (Default: \code{1e-8})}

\item{...}{(optional): Arguments passed to the SGD optimizer. Argument lr will default to 0.1 if not specied.(Default: \code{NULL})}
}
\value{
Tensor: Linear scale spectrogram of size (..., freq, time)
}
\description{
Solve for a normal STFT from a mel frequency STFT, using a conversion
matrix.  This uses triangular filter banks.
}
\details{
forward param:
melspec  (Tensor): A Mel frequency spectrogram of dimension (..., \code{n_mels}, time)

It minimizes the euclidian norm between the input mel-spectrogram and the product between
the estimated spectrogram and the filter banks using SGD.
}
