% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_equalizer_biquad}
\alias{functional_equalizer_biquad}
\title{Biquad Peaking Equalizer Filter (functional)}
\usage{
functional_equalizer_biquad(
  waveform,
  sample_rate,
  center_freq,
  gain,
  Q = 0.707
)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{center_freq}{(float): filter's central frequency}

\item{gain}{(float): desired gain at the boost (or attenuation) in dB}

\item{Q}{(float, optional): \url{https://en.wikipedia.org/wiki/Q_factor} (Default: \code{0.707})}
}
\value{
Tensor: Waveform of dimension of \verb{(..., time)}
}
\description{
Design biquad peaking equalizer filter and perform filtering.  Similar to SoX implementation.
}
