% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dogs-vs-cats.R
\name{dogs_vs_cats_dataset}
\alias{dogs_vs_cats_dataset}
\title{Dog vs cats dataset}
\usage{
dogs_vs_cats_dataset(root, token = NULL, download = TRUE, ...)
}
\arguments{
\item{root}{path to the data location}

\item{token}{a path to the json file obtained in Kaggle. See \href{https://pins.rstudio.com/reference/legacy_kaggle.html}{here}
for additional info.}

\item{download}{wether to download or not}

\item{...}{other arguments passed to \code{\link[torchvision:image_folder_dataset]{torchvision::image_folder_dataset()}}.}
}
\value{
A \code{\link[torch:dataset]{torch::dataset()}} ready to be used with dataloaders.
}
\description{
Prepares the dog vs cats dataset available in Kaggle
\href{https://www.kaggle.com/c/dogs-vs-cats}{here}
}
\examples{
if (torch::torch_is_installed() && FALSE) {
dogs_cats <- dogs_vs_cats_dataset("./data", token = "path/to/kaggle.json",
                                  download = TRUE)
length(dogs_cats)
}
}
