% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_glm.R
\name{importance.glm}
\alias{importance.glm}
\title{GLM variable importance plot}
\usage{
\method{importance}{glm}(model_final, model_null, dict = NA, ...)
}
\arguments{
\item{model_final}{a model object}

\item{model_null}{a glm object for the null model}

\item{dict}{a dictionary to translate the model variables to plotting variables}

\item{...}{arguments passed to other methods}
}
\value{
an object of type \code{importance_plot}
\item{type}{the type of importance plot}
\item{data}{the importance data required for the plot}
}
\description{
GLM variable importance plot
}
\examples{
gtest <- glm(mpg ~ cyl*wt*hp + gear + carb, data=mtcars, family=gaussian)
gtestreduced <- glm(mpg ~ 1, data=mtcars, family=gaussian)
imp <- importance(gtest, gtestreduced)
plot(imp)

gtest <- glm(mpg ~ cyl + wt + hp + gear + carb, data=mtcars, family=gaussian)
gtestreduced <- glm(mpg ~ 1, data=mtcars, family=gaussian)
imp <- importance(gtest, gtestreduced)
plot(imp)

gtest <- glm(vs ~ wt + disp + gear, data=mtcars, family=binomial(link="logit"))
gtestreduced <- glm(vs ~ 1, data=mtcars, family=binomial(link="logit"))
imp <- importance(gtest, gtestreduced)
plot(imp)
}
\seealso{
\code{\link{importance}}
}
