% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicCoherence.R
\name{topicCoherence}
\alias{topicCoherence}
\title{Calculating Topic Coherence}
\usage{
topicCoherence(
  ldaresult,
  documents,
  num.words = 10,
  by.score = TRUE,
  sym.coherence = FALSE,
  epsilon = 1
)
}
\arguments{
\item{ldaresult}{The result of a function call \code{\link{LDAgen}}}

\item{documents}{A list prepared by \code{\link{LDAprep}}.}

\item{num.words}{Integer: Number of topwords used for calculating topic coherence (default: \code{10}).}

\item{by.score}{Logical: Should the Score from \code{\link[lda]{top.topic.words}} be used (default: \code{TRUE})?}

\item{sym.coherence}{Logical: Should a symmetric version of the topic coherence used for the calculations? If TRUE the denominator of the topic coherence uses both wordcounts and not just one.}

\item{epsilon}{Numeric: Smoothing factor to avoid log(0). Default is 1. Stevens et al. recommend  a smaller value.}
}
\value{
A vector of topic coherences. the length of the vector corresponds to the number of topics in the model.
}
\description{
Implementationof Mimno's topic coherence.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus <- cleanTexts(corpus)
wordlist <- makeWordlist(corpus$text)
ldaPrep <- LDAprep(text=corpus$text, vocab=wordlist$words)

result <- LDAgen(documents=ldaPrep, K = 3L, vocab=wordlist$words, num.words=3)
topicCoherence(ldaresult=result, documents=ldaPrep, num.words=5, by.score=TRUE)
}
\references{
Mimno, David and Wallach, Hannah M. and Talley, Edmund and Leenders, Miriam and McCallum, Andrew. Optimizing semantic coherence in topic models. EMNLP '11 Proceedings of the Conference on Empirical Methods in Natural Language Processing, 2011.
Stevens, Keith and Andrzejewski, David and Buttler, David. Exploring topic coherence over many models and many topics. EMNLP-CoNLL '12 Proceedings of the 2012 Joint Conference on Empirical Methods in Natural Language Processing and Computational Natural Language Learning, 2012.
}
