% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{predict.numeric}
\alias{predict.numeric}
\title{Predict Method for Numeric Vectors}
\usage{
\method{predict}{numeric}(object, newdata, ...)
}
\arguments{
\item{object}{Named numeric vector of beta values. If an element is named
"Intercept", that element is interpreted as model intercept.}

\item{newdata}{Matrix with samples as rows and features as columns.}

\item{...}{further arguments passed to or from other methods}
}
\value{
Named numeric vector of predicted scores
}
\description{
Interprets the provided numeric vector as linear model and uses
it to generate predictions. If an element of the numeric vector has the name
\code{"Intercept"} this element is treated as the intercept of the linear model.
}
\examples{
X <- matrix(1:4, 2, 2, dimnames = list(c("s1", "s2"), c("a", "b")))
b <- c(Intercept = 3, a = 2, b = 1)
predict(b, X)
}
\keyword{S3}
