% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{sys.exit}
\alias{sys.exit}
\title{Terminate a non-interactive R Session}
\usage{
sys.exit(status = 0)
}
\arguments{
\item{status}{exitcode for R process}
}
\value{
No return value, called for side effects
}
\description{
Similar to python's
\href{https://docs.python.org/3/library/sys.html?highlight=exit#sys.exit}{sys.exit}.
If used interactively, code execution is stopped with an error message,
giving the provided status code. If used non-interactively (e.g. through
Rscript), code execution is stopped silently and the process exits with the
provided status code.
}
\examples{
\dontrun{
if (!file.exists("some.file")) {
  cat("Error: some.file does not exist.\n", file = stderr())
  sys.exit(1)
} else if (Sys.getenv("IMPORTANT_ENV") == "") {
  cat("Error: IMPORTANT_ENV not set.\n", file = stderr())
  sys.exit(2)
} else {
  cat("Everything good. Starting calculations...")
  # ...
  cat("Finished with success!")
  sys.exit(0)
}
}
}
\keyword{func}
