\name{grand_tour}
\alias{grand_tour}
\title{A grand tour path.}
\usage{grand_tour(d=2)}

\description{
  A grand tour path.
}

\details{
  This method generates target bases by randomly sampling on the space
  of all d-dimensional planes in p-space.

  Usually, you will not call this function directly, but will pass it
  to a method that works with tour paths like \code{\link{animate}},
  \code{\link{save_history}} or \code{\link{render}}.
}
\arguments{
  \item{d}{target dimensionality}
}
\examples{# All animation methods use the grand tour path by default
animate_dist(flea[, 1:6])
animate_xy(flea[, 1:6])
animate_pcp(flea[, 1:6])
animate_pcp(flea[, 1:6], grand_tour(4))

# The grand tour is a function:
tour2d <- grand_tour(2)
is.function(tour2d)

# with two parameters, the previous projection and the data set
args(tour2d)
# if the previous projection is null, it will generate a starting
# basis, otherwise the argument is ignored
tour2d(NULL, mtcars)
# the data argument is just used to determine the correct dimensionality
# of the output matrix
tour2d(NULL, mtcars[, 1:2])}
