% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc_per_plate}
\alias{qc_per_plate}
\title{Quality-control metrics calculation}
\usage{
qc_per_plate(d, assay_info, resp = "nval_median")
}
\arguments{
\item{d}{data.frame contains essential columns with the raw data.}

\item{assay_info}{assay_info list, contains names of primary and cytotox assay, names must match
what are provided in the raw data, under the column 'assay'.}

\item{resp}{response type, specify either 'nval_median' or 'nval_mean' for QC calculation}
}
\value{
three dataframe each representing negative control stats, positive control stats and QC metrics (CV_DMSO, Z' score, SSMD) for each assay plate
}
\description{
Calculate QC metrics, includin Z' score, CV of DMSO negative control, per assay plate.
}
\examples{
## calculate QC measures from demo data
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
qc <- qc_per_plate(demo_mc_norm, assay_info)

}
