% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc.ci.R
\name{proc.ci}
\alias{proc.ci}
\title{Partial AUC Inference}
\usage{
proc.ci(response, predictor, cp = 0.95, threshold = 0.9, method = "MW")
}
\arguments{
\item{response}{a factor, numeric or character vector of responses; 
typically encoded with 0 (negative) and 1 (positive). 
Only two classes can be used in a ROC curve. If its levels are not 0/1,
the first level will be defaultly regarded as negative.}

\item{predictor}{a numeric vector of the same length than response, containing the predicted value of each observation. An ordered factor is coerced to a numeric.}

\item{cp}{numeric; coverage probability of confidence interval.}

\item{threshold}{numeric; false positive rate (FPR) constraint.}

\item{method}{methods to estimate FPR-pAUC. \code{MW}: Mann-Whitney statistic. \code{expect}: method in (2.2) \href{http://www.ncbi.nlm.nih.gov/pubmed/20729218}{Wang and Chang, 2011}. \code{jackknife}: jackknife method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016}.}
}
\value{
Confidence interval of FPR partial AUC.
}
\description{
Infer the area of region under ROC curve with pre-specific FPR constraint (FPR-pAUC). See \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016} for details.
}
\details{
This function infers FPR partial AUC given response, predictor and pre-specific FPR constraint. The plot of corresponding ROC curve with pre-specific FPR is generated.
         \code{MW}: Mann-Whitney statistic. method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016} adapted from \href{http://www.ncbi.nlm.nih.gov/pubmed/20729218}{Wang and Chang, 2011}. \code{jackknife}: jackknife method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016}.
}
\examples{

library('pROC')
data(aSAH)
proc.ci(aSAH$outcome, aSAH$s100b, cp=0.95 ,threshold=0.9,method='expect')

}
\author{
Hanfang Yang, Kun Lu, Xiang Lyu, Feifang Hu.
}
\seealso{
\code{\link[tpAUC]{tproc.est}}, \code{\link[tpAUC]{podc.ci}}
}

