% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnFunctions.R
\name{testNN}
\alias{testNN}
\title{Train, validate and test artificial
neural networks}
\usage{
testNN(dat, stat = "F", maxH = 5, repetitions = 3, prop = c(8, 1, 1),
  predictors = NULL, pca = TRUE, thr = 0.95, ...)
}
\arguments{
\item{dat}{a previously constructed dataset obtained from 
\code{manuallySelect}.}

\item{stat}{Fit statistic. May be \code{"precision"}, \code{"recall"}, or
\code{"F"} for the harmonic mean of precision and recall.}

\item{maxH}{maximum number of hidden layers to test
note that more layers will require more time to fit.}

\item{repetitions}{the number of repetitions
for the neural network's training.}

\item{prop}{the proportion or ratio for each class
c(training, validation,test).}

\item{predictors}{Optional. A set of custom predictors
for the neural network. Default uses all columns in \code{dat}.}

\item{pca}{Logical. \code{TRUE} by default. Should the 
set of predictors be compressed to the most informative? In short, 
should a principal component analysis be conducted to select axis that
explain at least a fraction \code{thr} (see below) 
of the variance in the full set of predictors?}

\item{thr}{Threshold for pca (above).}

\item{\dots}{additional parameters, passed to neuralnet.}
}
\value{
Returns trained artificial neural net.
}
\description{
Fits multiple neural networks to
a dataset; data set has been randomly assigned to each
of three catergories: train, validate and test.
A final neural net is selected based on a fit statistic
(either precision, recall or the F1-score). All neural networks
are trained to the training dataset. Neural network may vary in
 the number of hidden layers. Classification thresholds are selected
based on the validation data, and then the final neural network
is selected based on the test data.
}
\details{
The neural networks may be selected based on precision, recall or
a F1-score (default).
In binary classification, precision is the number of correct positive
results divided by the number of all positive predictions. Recall is
the number of correct positive results divided by the number of positive
results that could have been returned if the algoritm was perfect.
A F1 score (F-score/ F-measure) is statistical
measure of accuracy. F1 scores considers both the precision
and the recall. A F1 score may be seen as a weighted average
(harmonic mean) of the precision and recall.
Precision, recall and F1 scores are at best 1 and at worst 0.
}
\examples{
\dontrun{
finalNN <- testNN(dat=trainingData,repetitions=5,maxH=4,prop=c(4,3,3))
summary(finalNN)
}
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
