% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentrationProfile.R
\name{ridges.conProfile}
\alias{ridges.conProfile}
\title{Ridgeline plots for \code{distrProfile} objects}
\usage{
\method{ridges}{conProfile}(x, session = NULL, what = NULL,
  smooth = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{conProfile} as returned by
\code{\link{concentration_profile}}.}

\item{session}{A numeric vector of the sessions to be plotted,
defaults to all sessions.}

\item{what}{Which variables should be plotted? Defaults to all
variables in \code{object} (\code{what = NULL}).}

\item{smooth}{Logical. Should unsmoothed profiles be smoothed
before plotting?}

\item{...}{Further arguments to be passed to
\code{\link{smoother_control.distrProfile}}.}
}
\description{
Ridgeline plots for \code{distrProfile} objects
}
\examples{
\dontrun{

data('runs', package = 'trackeR')
dProfile <- distributionProfile(runs, what = c('speed', 'heart_rate'))
cProfile <- concentrationProfile(dProfile)
ridges(cProfile, what = "speed")
ridges(cProfile, what = "heart_rate")
}
}
