% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjFeatureSet.R
\name{ObjFeatureSet}
\alias{ObjFeatureSet}
\alias{PlotFeatureSet}
\alias{GGplotFeatureSet}
\alias{TrellisFeatureSet}
\alias{GraphicsFeatureSet}
\alias{DFFeatureSet}
\alias{RmdFeatureSet}
\title{FeatureSet contstructors}
\usage{
ObjFeatureSet(object, code = as.character(parseCode(object)),
  codeinfo = CodeDepends::getInputs(parseCode(code)),
  klass = getTopS3Class(object), uniqueid = gen_hash_id(object),
  tags = character(), user = unname(Sys.info()["user"]),
  regdate = Sys.time(), analysispkg = scrape_descr(),
  analysisfile = .analysisFileOrNA(), rstudioproject = .rstudioProjOrNA(),
  fsetklass = "ObjFeatureSet", isplot = FALSE, generatedin = character(),
  clineargs = commandArgs(), resultURI = character(),
  provtable = ProvStoreDF(), ...)

PlotFeatureSet(object, fsetklass = "PlotFeatureSet",
  package = NA_character_, ...)

GGplotFeatureSet(object, fsetklass = "GGplotFeatureSet", ...)

TrellisFeatureSet(object, fsetklass = "TrellisFeatureSet", ...)

GraphicsFeatureSet(object, fsetklass = "GraphicsFeatureSet", ...)

DFFeatureSet(object, fsetklass = "DFFeatureSet", vars = names(object),
  varclasses = .makeClassesTab(object),
  varsummaries = structure(lapply(object, .makeSummaryTable), names =
  names(object)), nobs = nrow(object), ...)

RmdFeatureSet(rmdfile, outputfile, uniqueid,
  rmdfileid = gen_hash_id(readLines(rmdfile)), chunks,
  numouts = length(trackr_backend(objtdb)),
  numplots = sum(sapply(objrecords, function(x) x$isplot)), titles = "",
  author = "", textkeywords = character(), codekeywords = character(),
  outputids = sapply(objrecords, function(x) x$uniqueid, USE.NAMES = FALSE),
  tags = character(), user = unname(Sys.info()["user"]),
  regdate = Sys.time(), analysispkg = scrape_descr(),
  analysisfile = .analysisFileOrNA(), rstudioproject = .rstudioProjOrNA(),
  fsetklass = "RmdFeatureSet", objrecords = findRecords(".", db = objtdb),
  objtdb, figurefiles = NA_character_, resultURI = "", ...)
}
\arguments{
\item{object}{object to extract metadata from}

\item{code}{The code which generated the object. Do not manually
set}

\item{codeinfo}{Do not manually set}

\item{klass}{The class of the object. Do not manually set}

\item{uniqueid}{The uniqueID for the result. Do not manually
set. EVER.}

\item{tags}{Tags to associate with the object}

\item{user}{The user who recorded the object. Do not manually set}

\item{regdate}{The registration date/time. Do not manually set}

\item{analysispkg}{The analysis R package in which the session was
run. Do not manually set}

\item{analysisfile}{The .R file code was executed from to create
the object. Do not manually set}

\item{rstudioproject}{The RStudio project in which the object was
created. Do not manually set}

\item{fsetklass}{The FeatureSet subclass being created. This should
be overridden with custom FeatureSet subclasses}

\item{isplot}{Is the object a plot. Do not manually set.}

\item{generatedin}{The uniqueID of a parent result (e.g. an RMD
report the object was generated within). Do not manually set}

\item{clineargs}{The command-line arguments passed to the R session
in which the object was recorded. Do not manually set.}

\item{resultURI}{An optional character value which defines a
location within a hierarchical grouping for results tracked by
trackr. E.g. \code{'/groups/Becker/HousingData/analysis3'}}

\item{provtable}{A ProvStoreDF object containing "value lineage"
provenance information}

\item{...}{For ObjFeatureSet and RmdFeatureSet, unused. For Other
constructors, passed to the parent constructor.}

\item{package}{The plotting package used to create a plot.}

\item{vars}{Do not manually set}

\item{varclasses}{Do not manually set}

\item{varsummaries}{Do not manually set}

\item{nobs}{Do not manually set}

\item{rmdfile}{The (input) RMD file}

\item{outputfile}{the path to the woven report}

\item{rmdfileid}{Id associated with the input .Rmd file. Do not
manually set. EVER.}

\item{chunks}{The code and text chunks of the dynamic document}

\item{numouts}{Do not manually set}

\item{numplots}{Do not manually set}

\item{titles}{Do not manually set}

\item{author}{Do not manually set}

\item{textkeywords}{Keywords extracted from the text}

\item{codekeywords}{Keywords extracted from the code}

\item{outputids}{Do not manually set}

\item{objrecords}{Do not manually set. EVER.}

\item{objtdb}{The (temporary) trackerdb where individual displayed
outputs were recorded during the weaving process.}

\item{figurefiles}{image files of plot as figures for woven
report. Do not manually set.}
}
\value{
An object of a class that inherits from FeatureSet
}
\description{
Constructors for different typed FeatureSet subclasses. These
should only be used when customizing metadata extraction, i.e., in custom
makeFeatureSet methods. Not intended to be called directly by end users.
Because the arguments listed here unavoidably map to class slots, and because
most of them should NOT be set directly even in customization code, they are
semi-internal implementation details and are subject to change. 

Arguments described as 'Do not manually set' have default values
that should be used in virtually all cases. Overriding these in
custom makeFeatureSet methods can lead to undefined behavior by the
trackr system.
}
