% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{groupInfo}
\alias{groupInfo}
\alias{groupInfo,PlotFeatureSet-method}
\alias{groupInfo,ggplot-method}
\alias{groupInfo,trellis-method}
\alias{groupInfo,gTree-method}
\alias{groupInfo,PlotFeatureSet-method}
\title{Accessor method for the panel and other grouping information (slot "grouping") of the plot object.}
\usage{
groupInfo(object)

\S4method{groupInfo}{PlotFeatureSet}(object)

\S4method{groupInfo}{ggplot}(object)

\S4method{groupInfo}{trellis}(object)

\S4method{groupInfo}{gTree}(object)

\S4method{groupInfo}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of class  PlotFeatureSet, GGplotFeatureSet, TrellisFeatureSet, ggplot, or trellis.}
}
\value{
A named list of grouping information parameters.
}
\description{
Get the grouping info for a plot or PlotFeatureSet.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
groupInfo(fs)
}
