\name{newMriImageFromDicom}
\alias{newMriImageFromDicom}
\alias{newMriImageFromDicomDirectory}
\alias{newMriImageFromDicomMetadata}
\alias{newMriImageMetadataFromDicom}
\alias{newMriImageMetadataFromDicomMetadata}
\title{Functions for reading images from DICOM files}
\description{
  Functions for reading images from DICOM files.
}
\usage{
newMriImageFromDicom(fileName, untileMosaics = TRUE)
newMriImageFromDicomDirectory(dicomDir, readDiffusionParams = FALSE, untileMosaics = TRUE)
newMriImageFromDicomMetadata(metadata, flipY = TRUE, untileMosaics = TRUE)
newMriImageMetadataFromDicom(fileName, untileMosaics = TRUE)
newMriImageMetadataFromDicomMetadata(dicom, untileMosaics = TRUE)
}
\arguments{
  \item{fileName}{Character vector of length one giving the name of a DICOM file.}
  \item{untileMosaics}{Logical value: should Siemens mosaic images be converted into 3D volumes? This may occasionally be performed in error, which can be prevented by setting this value to \code{FALSE}.}
  \item{dicomDir}{Character vector of length one giving the name of a directory containing DICOM files.}
  \item{readDiffusionParams}{Logical value: should diffusion MRI parameters (b-values and gradient directions) be retrieved from the files if possible?}
  \item{metadata, dicom}{DicomMetadata objects.}
  \item{flipY}{Logical value: should the image be flipped in the Y direction? Usually this is appropriate to convert between DICOM's LPS and TractoR's LAS storage conventions.}
}
\value{
  \code{newMriImageFromDicom} and \code{newMriImageFromDicomMetadata} return an MriImage object. \code{newMriImageMetadataFromDicom} and \code{newMriImageMetadataFromDicomMetadata} return an MriImageMetadata object. \code{newMriImageFromDicomDirectory} returns a list containing elements
  \item{image}{An MriImage object.}
  \item{bValues}{Diffusion b-values, if requested. Will be NA if the information could not be found in the files.}
  \item{bVectors}{Diffusion gradient vectors, if requested. Will be NA if the information could not be found in the files.}
}
\author{Jon Clayden}
\references{
Please cite the following reference when using TractoR in your work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A. Clark (2011). TractoR: Magnetic resonance imaging and tractography with R. Journal of Statistical Software 44(8):1-18. \url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{\code{\link{DicomMetadata}}, \code{\link{MriImage}}, \code{\link{MriImageMetadata}}, \code{\link{sortDicomDirectory}}.}