% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.xgboost}
\alias{train.xgboost}
\title{train.xgboost}
\usage{
train.xgboost(formula, data, nrounds, watchlist = list(), obj = NULL,
  feval = NULL, verbose = 1, print_every_n = 1L,
  early_stopping_rounds = NULL, maximize = NULL, save_period = NULL,
  save_name = "xgboost.model", xgb_model = NULL, callbacks = list(),
  eval_metric = "mlogloss", extra_params = NULL, booster = "gbtree",
  objective = NULL, eta = 0.3, gamma = 0, max_depth = 6,
  min_child_weight = 1, subsample = 1, colsample_bytree = 1, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{training dataset. xgb.train accepts only an xgb.DMatrix as the input. xgboost, in addition, also accepts matrix, dgCMatrix, or name of a local data file.}

\item{nrounds}{max number of boosting iterations.}

\item{watchlist}{named list of xgb.DMatrix datasets to use for evaluating model performance.
Metrics specified in either eval_metric or feval will be computed for each of these
datasets during each boosting iteration, and stored in the end as a field named evaluation_log in the resulting object.
 When either verbose>=1 or cb.print.evaluation callback is engaged, the performance results are continuously printed out
 during the training. E.g., specifying watchlist=list(validation1=mat1, validation2=mat2) allows to track the performance
 of each round's model on mat1 and mat2.}

\item{obj}{customized objective function. Returns gradient and second order gradient with given prediction and dtrain.}

\item{feval}{custimized evaluation function. Returns list(metric='metric-name', value='metric-value') with given prediction and dtrain.}

\item{verbose}{If 0, xgboost will stay silent. If 1, it will print information about performance. If 2, some additional information will be printed out.
Note that setting verbose > 0 automatically engages the cb.print.evaluation(period=1) callback function.}

\item{print_every_n}{Print each n-th iteration evaluation messages when verbose>0. Default is 1 which means all messages are printed.
This parameter is passed to the cb.print.evaluation callback.}

\item{early_stopping_rounds}{If NULL, the early stopping function is not triggered. If set to an integer k,
training with a validation set will stop if the performance doesn't improve for k rounds.
Setting this parameter engages the cb.early.stop callback.}

\item{maximize}{If feval and early_stopping_rounds are set, then this parameter must be set as well. When it is TRUE, it means the larger
the evaluation score the better. This parameter is passed to the cb.early.stop callback.}

\item{save_period}{when it is non-NULL, model is saved to disk after every save_period rounds, 0 means save at the end. The saving is handled by the cb.save.model callback.}

\item{save_name}{the name or path for periodically saved model file.}

\item{xgb_model}{a previously built model to continue the training from. Could be either an object of class xgb.Booster, or its raw data, or the name
of a file with a previously saved model.}

\item{callbacks}{a list of callback functions to perform various task during boosting. See callbacks. Some of the callbacks are automatically created
depending on the parameters' values. User can provide either existing or their own callback methods in order to customize the training process.}

\item{eval_metric}{eval_metric evaluation metrics for validation data. Users can pass a self-defined function to it. Default: metric will be assigned
according to objective(rmse for regression, and error for classification, mean average precision for ranking). List is
provided in detail section.}

\item{extra_params}{the list of parameters. The complete list of parameters is available at http://xgboost.readthedocs.io/en/latest/parameter.html.}

\item{booster}{booster which booster to use, can be gbtree or gblinear. Default: gbtree.}

\item{objective}{objective specify the learning task and the corresponding learning objective, users can pass a self-defined function to it. The default objective options are below:
+ reg:linear linear regression (Default).
+ reg:logistic logistic regression.
+ binary:logistic logistic regression for binary classification. Output probability.
+ binary:logitraw logistic regression for binary classification, output score before logistic transformation.
+ num_class set the number of classes. To use only with multiclass objectives.
+ multi:softmax set xgboost to do multiclass classification using the softmax objective. Class is represented by a number and should be from 0 to num_class - 1.
+ multi:softprob same as softmax, but prediction outputs a vector of ndata * nclass elements, which can be further reshaped to ndata, nclass matrix. The result contains predicted probabilities of each data point belonging to each class.
+ rank:pairwise set xgboost to do ranking task by minimizing the pairwise loss.}

\item{eta}{eta control the learning rate: scale the contribution of each tree by a factor of 0 < eta < 1 when it is added to the current approximation.
Used to prevent overfitting by making the boosting process more conservative. Lower value for eta implies larger value for nrounds: low eta
value means model more robust to overfitting but slower to compute. Default: 0.3}

\item{gamma}{gamma minimum loss reduction required to make a further partition on a leaf node of the tree. the larger, the more conservative
the algorithm will be.gamma minimum loss reduction required to make a further partition on a leaf node of the tree. the larger, the more
conservative the algorithm will be.}

\item{max_depth}{max_depth maximum depth of a tree. Default: 6}

\item{min_child_weight}{min_child_weight minimum sum of instance weight (hessian) needed in a child. If the tree partition step results in a leaf node
with the sum of instance weight less than min_child_weight, then the building process will give up further partitioning. In linear
regression mode, this simply corresponds to minimum number of instances needed to be in each node. The larger, the more conservative
the algorithm will be. Default: 1}

\item{subsample}{subsample subsample ratio of the training instance. Setting it to 0.5 means that xgboost randomly collected half of the data instances to
grow trees and this will prevent overfitting. It makes computation shorter (because less data to analyse). It is advised to use this parameter
with eta and increase nrounds. Default: 1}

\item{colsample_bytree}{colsample_bytree subsample ratio of columns when constructing each tree. Default: 1}

\item{...}{other parameters to pass to params.}
}
\value{
A object xgb.Booster.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[xgboost]{xgb.train}}.
}
\note{
the parameter information was taken from the original function \code{\link[xgboost]{xgb.train}}.
}
\examples{

data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.xg <- train.xgboost(Species~., data.train, nrounds = 79, maximize = FALSE)
modelo.xg
prob <- predict(modelo.xg, data.test, type = "prob")
prob
prediccion <- predict(modelo.xg, data.test, type = "class")
prediccion
confusion.matrix(data.test, prediccion)

}
\seealso{
The internal function is from package \code{\link[xgboost]{xgb.train}}.
}
