% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{ROC.area}
\alias{ROC.area}
\title{ROC.area}
\usage{
ROC.area(prediction, real)
}
\arguments{
\item{prediction}{A vector of real numbers representing the prediction score of a category.}

\item{real}{A vector with the real categories of the individuals in the prediction.}
}
\value{
The value of the area(numeric).
}
\description{
Function that calculates the area of the ROC curve of a prediction with only 2 categories.
}
\examples{

iris2 <- dplyr::filter(iris,(Species == "setosa") | (Species == "virginica"))
iris2$Species <- factor(iris2$Species,levels = c("setosa","virginica"))
sam <- sample(1:100,20)
ttesting <- iris2[sam,]
ttraining <- iris2[-sam,]
model <- train.rpart(Species~.,ttraining)
prediction.prob <- predict(model,ttesting, type = "prob")
ROC.area(prediction.prob$prediction[,2],ttesting$Species)

}
\seealso{
\code{\link[ROCR]{prediction}} and \code{\link[ROCR]{performance}}
}
