% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coral.R
\name{coral}
\alias{coral}
\alias{coral_locations}
\alias{coral_methodologies}
\alias{coral_resources}
\alias{coral_species}
\alias{coral_taxa}
\alias{coral_traits}
\title{Search for coral data on coraltraits.org}
\usage{
coral_taxa(taxon, taxonomy = FALSE, contextual = TRUE, global = FALSE,
  ...)

coral_traits(trait, taxonomy = FALSE, contextual = TRUE, global = FALSE,
  ...)

coral_locations(location, taxonomy = FALSE, contextual = TRUE,
  global = FALSE, ...)

coral_methodologies(methodology, taxonomy = FALSE, contextual = TRUE,
  global = FALSE, ...)

coral_resources(resource, taxonomy = FALSE, contextual = TRUE,
  global = FALSE, ...)

coral_species(...)
}
\arguments{
\item{taxon}{A taxon id}

\item{taxonomy}{logical; Include contextual data. Default: FALSE}

\item{contextual}{logical; Include contextual data. Default: TRUE}

\item{global}{logical; Include contextual data. Default: FALSE}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{trait}{A trait id}

\item{location}{A location id}

\item{methodology}{A methodology id}

\item{resource}{A resource id}
}
\description{
Search for coral data on coraltraits.org
}
\examples{
\donttest{
# Get the species and their Ids
head( coral_species() )

# Get data by taxon
coral_taxa(80)

# Get data by trait
coral_traits(105)

# Get data by methodology
coral_methodologies(2)

# Get data by location
coral_locations(132)

# Get data by resource
coral_resources(10)

# curl options
library("httr")
coral_taxa(80, config=verbose())
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\references{
\url{http://coraltraits.org/}
}

