% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InternalTrajeR.R
\name{trajeR.NL}
\alias{trajeR.NL}
\title{Internal function to fit Non Linear Model}
\usage{
trajeR.NL(
  Y,
  A,
  X,
  TCOV,
  ng,
  nx,
  n,
  nbeta,
  nw,
  ntheta,
  period,
  degre,
  theta,
  beta,
  sigma,
  pi,
  Method,
  ssigma,
  hessian,
  itermax,
  paraminit,
  EMIRLS,
  refgr,
  fct,
  diffct,
  nls.lmiter
)
}
\arguments{
\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{X}{Matrix. An optional matrix that modify the probability of belong to group. By default its value is a matrix
with one column  with value 1.}

\item{TCOV}{Matrix. An optional matrix containing the time covariate that influence the trajectory themselves.
By default its value is NULL.}

\item{ng}{Integer. The number of groups.}

\item{nx}{Integer. The number of covariates.}

\item{n}{Integer. Number of individuals.}

\item{nbeta}{Vector of integers. Number of beta parameters for each group.}

\item{nw}{Integer. Number of time dependent covariate.}

\item{ntheta}{Vector of integers. Number of theta parameters for each group.}

\item{period}{Integer.}

\item{degre}{Vector of integer. The degree of every polynomial function.}

\item{theta}{Vector of real. The parameter for calculated the group membership probability.}

\item{beta}{Vector of real. The beta parameter.}

\item{sigma}{Vector of real. The sigma parameter.}

\item{pi}{Vector of real. The group membership probability.}

\item{Method}{String. Determine the method used for find the parameters of the model.
The value are L for the Maximum Likelihood Estimation, EM for Expectation Maximization method
with quasi newton method inside, EMIWRLS for Expectation Maximization method with Iterative
Weighted Least Square.}

\item{ssigma}{Logical. By default its value is FALSE. For the CNORM model,
indicate if we want the same sigma for all normal density function.}

\item{hessian}{Logical. Indicate if we want calculate the hessian matrix. Default is FALSE.
If the method use is Likelihood, the hessian is calculated by inverting the Information's Fisher Matrix.
To avoid numerically singular matrix we find the pseudo inverse matrix by using the \code{ginv} function int he package MASS.
If the method is EM or EMIWRLS, the hessian is calculated by using Louis method.}

\item{itermax}{Integer. Indicate the maximal number of iteration for \code{optim} function or for the EM algorithm.}

\item{paraminit}{Vector. The vector of initial parameters. By default \code{trajeR} calculate the initial value
based of the range or the standard deviation.}

\item{EMIRLS}{Boolean. True if we use EMIRLS method.}

\item{refgr}{Integer. The number of reference group. By default is 1.}

\item{fct}{Function. The definition of the function  f in the definition in nonlinear model.}

\item{diffct}{Function. The differential of the function f in the nonlinear model.}

\item{nls.lmiter}{Integer. In the case of non linear model, the maximum number of iterations allowed.}
}
\value{
return a object of class Trajectory.NL
\itemize{
  \item beta -  vector of the parameter beta.
  \item sigma - vector of the parameters sigma.
  \item delta - vector of the parameter delta. Only if we use time covariate.
  \item theta - vector with the parameter theta if there exist a coavriate X that modify
  the probability or the probability of group membership.
  \item sd - vector of the standard deviation of the parameters.
  \item tab - a matrix with all the parameters and standard deviation.
  \item Model - a string with the model used.
  \item groups -  a integer with the number of group.
  \item Names - strings with the name of the parameters.
  \item Method  -  a string with the method used.
  \item Size - a integer with the number of individuals.
  \item Likelihood -  a real with the Likelihood obtained by the parameters.
  \item Time - a vector with the first row of time values.
  \item degre - a vector with the degree of the polynomial shape.
  \item fct - the defintion of the function used int this model.
}
}
\description{
Internal function to fit Non Linear Model
}
