% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{TrajFromTrjPoints}
\alias{TrajFromTrjPoints}
\title{Create a trajectory from a subset of another}
\usage{
TrajFromTrjPoints(trj, idx)
}
\arguments{
\item{trj}{Trajectory to extract points and metadata from.}

\item{idx}{Indices of the points in \code{trj} to retain in the new
trajectory.}
}
\value{
A new trajectory which is the same as \code{trj} except with a subset
  of points.
}
\description{
Creates a trajectory from a subset of the points in another trajectory,
preserving metadata and all columns in the original trajectory.
}
\details{
Note that removing points from a trajectory that does not contain a time
column will change the timing of the points, and hence change velocity etc.
}
\examples{
\dontrun{
# Create a trajectory (trj2) by removing all zero-length
# segments from another trajectory (trj). Keep all points
# that are different from their preceding point, and also
# keep the start point
trj2 <- TrajFromTrjPoints(trj, c(1, which(Mod(trj$displacement) != 0)))
}

}
