% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{PolrME}
\alias{PolrME}
\title{Mixed-effects version of \code{\link[tram]{Polr}}}
\usage{
PolrME(
  formula,
  data,
  subset,
  weights,
  offset,
  na.action = na.omit,
  method = c("logistic", "probit", "loglog", "cloglog"),
  silent = TRUE,
  resid = FALSE,
  do_update = FALSE,
  estinit = TRUE,
  initpar = NULL,
  fixed = NULL,
  nofit = FALSE,
  control = optim_control(),
  ...
)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description 
          of the model structure to be
          fitted.  The details of model specification are given under
          \code{\link[tram]{tram}} and in the package vignette.
  }

\item{data}{an optional data frame, list or environment (or object
          coercible by \code{as.data.frame} to a data frame) containing the
          variables in the model.  If not found in \code{data}, the
          variables are taken from \code{environment(formula)}.
  }

\item{subset}{an optional vector specifying a subset of observations to be
          used in the fitting process.
  }

\item{weights}{an optional vector of weights to be used in the fitting
          process.  Should be \code{NULL} or a numeric vector. If present,
          the weighted log-likelihood is maximised.
  }

\item{offset}{this can be used to specify an _a priori_ known component to
          be included in the linear predictor during fitting.  This
          should be \code{NULL} or a numeric vector of length equal to the
          number of cases.
  }

\item{na.action}{a function which indicates what should happen when the data
          contain \code{NA}s.  The default is set to \code{na.omit}.
  }

\item{method}{a character describing the link function.
  }

\item{silent}{Logical. Make \pkg{TMB} functionality silent.}

\item{resid}{Logical. If \code{TRUE}, the score residuals are also calculated.
This comes with some performance cost.}

\item{do_update}{Logical. If \code{TRUE}, the model is set up so that the weights and the
offsets are updateable. This comes with some performance cost.}

\item{estinit}{logical, estimate a vector of initial values for the fixed effects parameters
from a (fixed effects only) mlt model}

\item{initpar}{named list of initial parameter values, if \code{NULL}, it is ignored}

\item{fixed}{a named vector of fixed regression coefficients; the names
               need to correspond to column names of the design matrix}

\item{nofit}{logical, if TRUE, creates the model object, but does not run the optimization}

\item{control}{list with controls for optimization}

\item{...}{additional arguments to \code{\link[tram]{tram}}.}
}
\value{
A PolrME object.
}
\description{
Mixed-effects version of \code{\link[tram]{Polr}}
}
