% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssSortVariables.R
\name{xpssSortVariables}
\alias{xpssSortVariables}
\title{Sorting variables}
\usage{
xpssSortVariables(x, by = NULL, order = "A")
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class "xpssFrame".}

\item{by}{atomic character with the name of the argument to sort by}

\item{order}{atomic character which indicate the sort direction.}
}
\value{
Returns \code{x} sorted by the \code{by} argument.
}
\description{
R implementation of the SPSS \code{SORT VARIABLES} function.
}
\details{
\code{x} can be sorted based on the following \code{by} arguments.
 \itemize{
 \item \emph{NAME.} Sort by variable names. Primary sort is alphabetical. Trailing digits are sorted numerically
 \item \emph{TYPE.} Sort variables by type (numeric or string). Sort string variables by width.
 \item \emph{LABEL.} Sort variables alphabetical by variable labels.
 \item \emph{COLUMNS.} Sort variables by column width.
 }
 Valid input for order are "Up" or "Down", respectively "A" or "D".
}
\examples{
data(fromXPSS)

xpssSortVariables(fromXPSS, by = "NAME")

xpssSortVariables(fromXPSS, by = "NAME", order = "D")

xpssSortVariables(fromXPSS, by = "TYPE", order = "A")

xpssSortVariables(fromXPSS, by = "TYPE", order = "D")

xpssSortVariables(fromXPSS, by = "COLUMNS", order = "A")

xpssSortVariables(fromXPSS, by = "COLUMNS", order = "D")
}
\author{
Benjamin Piest
}
\seealso{
\code{\link{sort}}
}

