% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssValueLabels.R
\name{xpssValueLabels}
\alias{xpssValueLabels}
\title{Modifies value labels}
\usage{
xpssValueLabels(x, variables = NULL, values = NULL, labels = NULL,
  datevariables = NULL, datevalues = NULL, datelabels = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class "xpssFrame".}

\item{variables}{atomic character or character vector with the names of the variables.}

\item{values}{atomic numeric or numeric vector containing the values of the variable.}

\item{labels}{atomic character or character vector containing the variable labels.}

\item{datevariables}{atomic date or date vector with the names of the date variables.}

\item{datevalues}{atomic date or date vector containing the value of the date, the values has to be like the old date format.}

\item{datelabels}{atomic character or character vector containing the date labels.}
}
\description{
R implementation of the SPSS \code{VALUE LABEL} function. xpssValueLabels creates value labels for specific variables. The values of the label get stored in attributes of the variable.
}
\details{
The SPSS variables are stored at the variable itself.
\cr In contrast to \code{\link{xpssAddValueLabels}} , \code{\link{xpssValueLabels}} does erase existing value labels. \cr If the value label for a specific variable already exists, all value labels for that variable get overwritten. \cr If the value label for a specific variable does not exist, the value label gets created and all existing value labels for that variable get deleted.
\cr\cr A variable can have the following attributes:
\code{value.labels}, \code{defined.MIS}, \code{MIS}, \code{varname}, \code{variable.label}
}
\examples{
data(fromXPSS)

temp <- xpssValueLabels(fromXPSS,
                           variables = "V1",
                           value = 1 ,
                           label = "Label1")

fromXPSS <- xpssAddValueLabels(fromXPSS,
                           variables = "V1",
                           values = c("A","B"),
                           labels = c("Label1","Label2"))
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{xpssAddValueLabels}} \code{\link{xpssVariableLabels}}
}

