% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{translate}
\alias{translate}
\title{Translate Text}
\usage{
translate(
  ...,
  lang = language_get(),
  tr = translator(),
  concat = constant("concat"),
  source_lang = language_source_get()
)
}
\arguments{
\item{...}{Any number of literal character vectors. The source text to
translate. Values can be empty and/or \link[base:NA]{NA}, but this may lead
to unexpected results.}

\item{lang}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}

\item{tr}{A \code{\link{Translator}} object.}

\item{concat}{A non-empty and non-\link[base:NA]{NA} character string used to
concatenate values passed to \code{...}.}

\item{source_lang}{A non-empty and non-\link[base:NA]{NA} character string. The
language of the (untranslated) source text. See argument \code{lang} for more
information.}
}
\value{
A character string, or \code{NULL} if the underlying translation is unavailable.
}
\description{
Translate source text.
}
\details{
It is strongly recommended to always include the namespace when using
\code{\link[=translate]{translate()}}, i.e. \code{transltr::translate()}. Doing so ensures that there
will be no ambiguity at runtime. See argument \code{strict} of \code{\link[=find_source]{find_source()}}
for additional information.
}
\examples{
# Set source language.
language_source_set("en")

# Create a Translator object.
# This would normally be done automatically
# by find_source(), or translator_read().
tr <- translator(
  id = "test-translator",
  en = "English",
  fr = "Français",
  text(
    en = "Hello, world!",
    fr = "Bonjour, monde!"),
  text(
    en = "Farewell, world!",
    fr = "Au revoir, monde!"))

# Set current language.
language_set("fr")

# Request translations.
translate("Hello, world!")                           ## Outputs "Bonjour, monde!"
translate("Farewell, world!", lang = "fr", tr = tr)  ## Outputs "Au revoir, monde!"
translate("Hello, world!",    lang = "en", tr = tr)  ## Outputs "Hello, world!"

}
\seealso{
\code{\link{Translator}},
\code{\link[=language_set]{language_set()}}
}
