package jpsgcs.alun.hashing;

import jpsgcs.alun.util.RandomBag;
import java.util.Collection;

public class RandomSet<E> extends LinkedHashSet<E> implements RandomBag<E>
{
	public RandomSet()
	{
		super();
		maxOccupancy = 0;
	}

	public RandomSet(Collection<? extends E> c)
	{
		super(c);
		setMaxOccupancy();
	}

	public boolean add(E x)
	{
		boolean result = super.add(x);
		if (result)
		{
			HashMap.Entry<E,Object>[] tab = map().table();
			int i = map().indexFor(map().hash(x),tab.length);
			i = occupancy(tab[i]);
			if (i > maxOccupancy)
				maxOccupancy = i;
		}
		return result;
	}

	public boolean remove(Object x)
	{
		boolean result = super.remove(x);
		if (result)
		{
			HashMap.Entry<E,Object>[] tab = map().table();
			int i = map().indexFor(map().hash(x),tab.length);
			i = occupancy(tab[i]);
			if (i+1 == maxOccupancy)
				setMaxOccupancy();
		}
		return result;
	}

	public boolean addAll(Collection<? extends E> c)
	{
		boolean result = super.addAll(c);
		if (result)
			setMaxOccupancy();
		return result;
	}

	public boolean removeAll(Collection<?> c)
	{
		boolean result = super.removeAll(c);
		if (result)
			setMaxOccupancy();
		return result;
	}

	public boolean retainAll(Collection<?> c)
	{
		boolean result = super.retainAll(c);
		if (result)
			setMaxOccupancy();
		return result;
	}

	public E next()
	{
		if (isEmpty())
			return null;

		if (map().resized)
		{
			setMaxOccupancy();
			map().resized = false;
		}

		HashMap.Entry<E,Object>[] tab = map().table();

		int i = 0;
		int j = 0;
		do
		{
			i = (int)(Math.random() * tab.length);
			j = occupancy(tab[i]);
		}
		while (Math.random() * maxOccupancy > j);

		double x = Math.random() * j;
		j = 0;
		for (HashMap.Entry<E,Object> e = tab[i]; e != null; e = e.next)
			if (x <= ++j)
				return e.getKey();

		return null;
	}

	public E draw()
	{
		E x = next();
		if (x != null)
			remove(x);
		return x;
	}

// Private data and methods.

	protected int maxOccupancy = 0;

	protected void setMaxOccupancy()
	{
		HashMap.Entry<E,Object>[] tab = map().table();
		maxOccupancy = 0;
		for (int i=0; i<tab.length; i++)
			if (maxOccupancy < occupancy(tab[i]))
				maxOccupancy = occupancy(tab[i]);
	}

	protected int occupancy(HashMap.Entry x)
	{
		int i = 0;
		while (x != null)
		{
			i++;
			x = x.next;
		}
		return i;
	}

	public static void main(String[] args)
	{
		try
		{
			int[] count = new int[10000];
			int s = 10000000;

			RandomSet<Integer> x = new RandomSet<Integer>();
			for (int i=0; i<count.length; i++)
				x.add(i);

			for (int i=0; i<s; i++)
				count[x.next().intValue()]++;

			for (int i=0; i<count.length; i++)
				System.out.println(count[i]);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
