% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{meld_na}
\alias{meld_na}
\title{MELD-Na score}
\usage{
meld_na(INR, bili, creat, Na, dialysis, units = "SI")
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of bilirubin (µmol/l)}

\item{creat}{numeric vector of creatinine (µmol/l)}

\item{Na}{numeric vector of sodium (mmol/l)}

\item{dialysis}{whether on dialysis/CVVH (1 = yes, 0 = no)}

\item{units}{Units for bilirubin and creatinine ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
numeric vector of MELD-Na scores
}
\description{
A vectorised function to calculate the MELD-Na score, a variant of the MELD score incorporating
serum sodium levels. By default, bilirubin and creatinine are in µmol/l but this can be
changed to mg/dl by setting the optional units parameter to "US".
}
\details{
Reference: Biggins SW, Kim WR, Terrault NA, et al. Evidence-based incorporation of serum sodium
concentration into MELD. Gastroenterology 2006; 130(6):1652-60.
}
\examples{
meld_na(INR = 1.8, bili = 34, creat = 176, Na = 131, dialysis = 0)
meld_na(INR = 1.8, bili = 2, creat = 2, Na = 131, dialysis = 0, units = "US")
}
