% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{compare}
\alias{compare}
\title{Cross-validation (reproducibility)}
\usage{
compare(
  target,
  source = NULL,
  prior = NULL,
  z = NULL,
  family,
  alpha,
  scale = "iso",
  sign = FALSE,
  switch = FALSE,
  select = TRUE,
  foldid.ext = NULL,
  nfolds.ext = 10,
  foldid.int = NULL,
  nfolds.int = 10,
  type.measure = "deviance",
  alpha.prior = NULL,
  naive = TRUE,
  seed = NULL,
  cores = 1,
  xrnet = FALSE
)
}
\arguments{
\item{target}{list with slot x (feature matrix with n rows and p columns) and slot y (target vector of length n)}

\item{source}{list of k lists, each with slot x (feature matrix with m_i rows and p columns) and slot y (target vector of length m_i)}

\item{prior}{prior coefficients: matrix with \eqn{p} rows (features)
and \eqn{k} columns (sources of co-data)}

\item{z}{prior weights}

\item{family}{character "gaussian" (\eqn{y}: real numbers),
"binomial" (\eqn{y}: 0s and 1s),
or "poisson" (\eqn{y}: non-negative integers);}

\item{alpha}{elastic net mixing parameter (0=ridge, 1=lasso):
number between 0 and 1}

\item{scale}{character
"exp" for exponential calibration or
"iso" for isotonic calibration}

\item{sign}{sign discovery procedure: logical
(experimental argument)}

\item{switch}{choose between positive and negative weights for each source: logical}

\item{select}{select from sources: logical}

\item{foldid.ext}{external fold identifiers}

\item{nfolds.ext}{number of external folds}

\item{foldid.int}{internal fold identifiers}

\item{nfolds.int}{number of internal folds}

\item{type.measure}{character}

\item{alpha.prior}{alpha for source regression}

\item{naive}{compare with naive transfer learning: logical}

\item{seed}{random seed}

\item{cores}{number of cores for parallel computing
(requires R package \code{doMC})}

\item{xrnet}{compare with xrnet: logical}
}
\description{
Function for reproducing hold-out method (simulation)
and \eqn{k}-fold cross-validation (application).
See vignette.
}
\seealso{
\code{\link[=transreg]{transreg()}}
}
