% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_case_mix.r
\name{trauma_case_mix}
\alias{trauma_case_mix}
\title{View the Current Patient Population Case Mix Compared to the Major Trauma
Study Case Mix}
\usage{
trauma_case_mix(df, Ps_col, outcome_col)
}
\arguments{
\item{df}{A data frame containing patient data.}

\item{Ps_col}{The name of the column containing the probability of survival
(Ps) values.}

\item{outcome_col}{The name of the column containing the binary outcome data
(valid values are 1 or TRUE for alive, 0 or FALSE for dead).}
}
\value{
A data frame containing the Ps ranges, the fraction of patients in
each range in the current population, and the MTOS distribution for each
range.
}
\description{
This function compares the current patient population's case mix (based on
probability of survival, Ps) to the MTOS case mix by binning patients into
specific Ps ranges. It returns the fraction of patients in each range and
compares it to the MTOS distribution. For more information on the methods used
in these calculations, please see Flora (1978) and Boyd et al. (1987).
}
\details{
The function checks whether the \code{outcome_col} contains exactly two
unique values representing a binary outcome. It also ensures that \code{Ps_col}
contains numeric values within the range 0 to 100. If any values exceed 1,
they are converted to decimal format. The patients are then grouped into
predefined Ps ranges, and the function compares the fraction of patients in
each range with the MTOS case mix distribution.
}
\examples{
# Generate example data with high negative skewness
set.seed(123)

# Parameters
n_patients <- 10000  # Total number of patients

# Generate survival probabilities (Ps) using a logistic distribution
set.seed(123)  # For reproducibility
Ps <- plogis(rnorm(n_patients, mean = 2, sd = 1.5))  # Skewed towards higher values

# Simulate survival outcomes based on Ps
survival_outcomes <- rbinom(n_patients, size = 1, prob = Ps)

# Create data frame
data <- data.frame(Ps = Ps, survival = survival_outcomes) |>
dplyr::mutate(death = dplyr::if_else(survival == 1, 0, 1))

# Compare the current case mix with the MTOS case mix
trauma_case_mix(data, Ps_col = Ps, outcome_col = death)

}
\author{
Nicolas Foss, Ed.D., MS
}
