% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitMarginalDistributions.R
\name{fit_marginalPoisson}
\alias{fit_marginalPoisson}
\title{Fits a Poisson distribution as marginal law}
\usage{
fit_marginalPoisson(x, LM, plotdiag = FALSE)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{LM}{Lebesgue measure of the estimated trawl}

\item{plotdiag}{binary variable specifying whether or not diagnostic plots
should be provided}
}
\value{
v: the rate parameter in the Poisson marginal distribution
}
\description{
Fits a Poisson distribution as marginal law
}
\details{
The moment estimator for the Poisson rate parameter is given by
 \deqn{\hat v = \mbox{E}(X)/\widehat{ \mbox{LM}}.}
}
\examples{
\donttest{
#Simulate a univariate trawl process and fit the exponential trawl function
#and the marginal Poisson law
set.seed(1)
t <- 1000
Delta <- 1
v <- 250
lambda <- 0.25
#Simulate a univariate trawl process with exponential trawl function and
#Poisson marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("Poi"),trawl
="Exp",v=v, lambda1=lambda)
#Fit the exponential trawl function to the simulated data
fittrawlfct <- fit_Exptrawl(trawl,Delta, plotacf=TRUE,lags=500)
#Fit the Poisson marginal law
fitmarginallaw <- fit_marginalPoisson(trawl, fittrawlfct$LM, plotdiag=TRUE)
#Print the results
print(paste("lambda: estimated:", fittrawlfct$lambda, ", theoretical:",
lambda))
print(paste("v: estimated:", fitmarginallaw$v, ", theoretical:", v))
}
}
