
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_cont_binary_mlm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_cont_binary_mlm : public prob_grad {
private:
    int N;
    int J;
    int P;
    matrix_d x;
    vector<int> g;
    vector<int> z;
    vector_d y;
    double zeta_z;
    double zeta_y;
    double theta;
    vector_d z_real;
public:
    model_cont_binary_mlm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_cont_binary_mlm(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_cont_binary_mlm_namespace::model_cont_binary_mlm";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "P", "int", context__.to_vec());
        P = int(0);
        vals_i__ = context__.vals_i("P");
        pos__ = 0;
        P = vals_i__[pos__++];
        context__.validate_dims("data initialization", "x", "matrix_d", context__.to_vec(N,P));
        validate_non_negative_index("x", "N", N);
        validate_non_negative_index("x", "P", P);
        x = matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(P));
        vals_r__ = context__.vals_r("x");
        pos__ = 0;
        size_t x_m_mat_lim__ = N;
        size_t x_n_mat_lim__ = P;
        for (size_t n_mat__ = 0; n_mat__ < x_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < x_m_mat_lim__; ++m_mat__) {
                x(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "g", "int", context__.to_vec(N));
        validate_non_negative_index("g", "N", N);
        g = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("g");
        pos__ = 0;
        size_t g_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < g_limit_0__; ++i_0__) {
            g[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "z", "int", context__.to_vec(N));
        validate_non_negative_index("z", "N", N);
        z = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("z");
        pos__ = 0;
        size_t z_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < z_limit_0__; ++i_0__) {
            z[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "N", N);
        y = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
            y[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "zeta_z", "double", context__.to_vec());
        zeta_z = double(0);
        vals_r__ = context__.vals_r("zeta_z");
        pos__ = 0;
        zeta_z = vals_r__[pos__++];
        context__.validate_dims("data initialization", "zeta_y", "double", context__.to_vec());
        zeta_y = double(0);
        vals_r__ = context__.vals_r("zeta_y");
        pos__ = 0;
        zeta_y = vals_r__[pos__++];
        context__.validate_dims("data initialization", "theta", "double", context__.to_vec());
        theta = double(0);
        vals_r__ = context__.vals_r("theta");
        pos__ = 0;
        theta = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"N",N,0);
        check_greater_or_equal(function__,"J",J,0);
        check_greater_or_equal(function__,"P",P,0);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"g[k0__]",g[k0__],1);
            check_less_or_equal(function__,"g[k0__]",g[k0__],J);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"z[k0__]",z[k0__],0);
            check_less_or_equal(function__,"z[k0__]",z[k0__],1);
        }
        check_greater_or_equal(function__,"theta",theta,0.0);
        check_less_or_equal(function__,"theta",theta,1.0);
        // initialize data variables
        validate_non_negative_index("z_real", "N", N);
        z_real = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        stan::math::fill(z_real,DUMMY_VAR__);

        try {
            stan::math::assign(z_real, to_vector(z));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        check_greater_or_equal(function__,"z_real",z_real,0.0);
        check_less_or_equal(function__,"z_real",z_real,1.0);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += J;
        num_params_r__ += J;
        ++num_params_r__;
        num_params_r__ += P;
        num_params_r__ += P;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_cont_binary_mlm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("ranef_treatment")))
            throw std::runtime_error("variable ranef_treatment missing");
        vals_r__ = context__.vals_r("ranef_treatment");
        pos__ = 0U;
        context__.validate_dims("initialization", "ranef_treatment", "vector_d", context__.to_vec(J));
        // generate_declaration ranef_treatment
        vector_d ranef_treatment(static_cast<Eigen::VectorXd::Index>(J));
        for (int j1__ = 0U; j1__ < J; ++j1__)
            ranef_treatment(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ranef_treatment);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ranef_treatment: ") + e.what());
        }

        if (!(context__.contains_r("ranef_response")))
            throw std::runtime_error("variable ranef_response missing");
        vals_r__ = context__.vals_r("ranef_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "ranef_response", "vector_d", context__.to_vec(J));
        // generate_declaration ranef_response
        vector_d ranef_response(static_cast<Eigen::VectorXd::Index>(J));
        for (int j1__ = 0U; j1__ < J; ++j1__)
            ranef_response(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ranef_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ranef_response: ") + e.what());
        }

        if (!(context__.contains_r("treatmentEffect")))
            throw std::runtime_error("variable treatmentEffect missing");
        vals_r__ = context__.vals_r("treatmentEffect");
        pos__ = 0U;
        context__.validate_dims("initialization", "treatmentEffect", "double", context__.to_vec());
        // generate_declaration treatmentEffect
        double treatmentEffect(0);
        treatmentEffect = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(treatmentEffect);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable treatmentEffect: ") + e.what());
        }

        if (!(context__.contains_r("beta_treatment")))
            throw std::runtime_error("variable beta_treatment missing");
        vals_r__ = context__.vals_r("beta_treatment");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_treatment", "vector_d", context__.to_vec(P));
        // generate_declaration beta_treatment
        vector_d beta_treatment(static_cast<Eigen::VectorXd::Index>(P));
        for (int j1__ = 0U; j1__ < P; ++j1__)
            beta_treatment(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_treatment);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_treatment: ") + e.what());
        }

        if (!(context__.contains_r("beta_response")))
            throw std::runtime_error("variable beta_response missing");
        vals_r__ = context__.vals_r("beta_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_response", "vector_d", context__.to_vec(P));
        // generate_declaration beta_response
        vector_d beta_response(static_cast<Eigen::VectorXd::Index>(P));
        for (int j1__ = 0U; j1__ < P; ++j1__)
            beta_response(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_response: ") + e.what());
        }

        if (!(context__.contains_r("sigma_response")))
            throw std::runtime_error("variable sigma_response missing");
        vals_r__ = context__.vals_r("sigma_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_response", "double", context__.to_vec());
        // generate_declaration sigma_response
        double sigma_response(0);
        sigma_response = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0.0,sigma_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_response: ") + e.what());
        }

        if (!(context__.contains_r("sigma_ranef_treatment")))
            throw std::runtime_error("variable sigma_ranef_treatment missing");
        vals_r__ = context__.vals_r("sigma_ranef_treatment");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_ranef_treatment", "double", context__.to_vec());
        // generate_declaration sigma_ranef_treatment
        double sigma_ranef_treatment(0);
        sigma_ranef_treatment = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0.0,sigma_ranef_treatment);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_ranef_treatment: ") + e.what());
        }

        if (!(context__.contains_r("sigma_ranef_response")))
            throw std::runtime_error("variable sigma_ranef_response missing");
        vals_r__ = context__.vals_r("sigma_ranef_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_ranef_response", "double", context__.to_vec());
        // generate_declaration sigma_ranef_response
        double sigma_ranef_response(0);
        sigma_ranef_response = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0.0,sigma_ranef_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_ranef_response: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ranef_treatment;
        (void) ranef_treatment;  // dummy to suppress unused var warning
        if (jacobian__)
            ranef_treatment = in__.vector_constrain(J,lp__);
        else
            ranef_treatment = in__.vector_constrain(J);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ranef_response;
        (void) ranef_response;  // dummy to suppress unused var warning
        if (jacobian__)
            ranef_response = in__.vector_constrain(J,lp__);
        else
            ranef_response = in__.vector_constrain(J);

        T__ treatmentEffect;
        (void) treatmentEffect;  // dummy to suppress unused var warning
        if (jacobian__)
            treatmentEffect = in__.scalar_constrain(lp__);
        else
            treatmentEffect = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_treatment;
        (void) beta_treatment;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_treatment = in__.vector_constrain(P,lp__);
        else
            beta_treatment = in__.vector_constrain(P);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_response;
        (void) beta_response;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_response = in__.vector_constrain(P,lp__);
        else
            beta_response = in__.vector_constrain(P);

        T__ sigma_response;
        (void) sigma_response;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_response = in__.scalar_lb_constrain(0.0,lp__);
        else
            sigma_response = in__.scalar_lb_constrain(0.0);

        T__ sigma_ranef_treatment;
        (void) sigma_ranef_treatment;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_ranef_treatment = in__.scalar_lb_constrain(0.0,lp__);
        else
            sigma_ranef_treatment = in__.scalar_lb_constrain(0.0);

        T__ sigma_ranef_response;
        (void) sigma_ranef_response;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_ranef_response = in__.scalar_lb_constrain(0.0,lp__);
        else
            sigma_ranef_response = in__.scalar_lb_constrain(0.0);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  log_p1(static_cast<Eigen::VectorXd::Index>(N));
        (void) log_p1;  // dummy to suppress unused var warning
        stan::math::initialize(log_p1, DUMMY_VAR__);
        stan::math::fill(log_p1,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  log_p0(static_cast<Eigen::VectorXd::Index>(N));
        (void) log_p0;  // dummy to suppress unused var warning
        stan::math::initialize(log_p0, DUMMY_VAR__);
        stan::math::fill(log_p0,DUMMY_VAR__);


        try {
            {
                T__ sigma_sq_response;
                (void) sigma_sq_response;  // dummy to suppress unused var warning
                stan::math::initialize(sigma_sq_response, DUMMY_VAR__);
                stan::math::fill(sigma_sq_response,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  linpred_treatment(static_cast<Eigen::VectorXd::Index>(N));
                (void) linpred_treatment;  // dummy to suppress unused var warning
                stan::math::initialize(linpred_treatment, DUMMY_VAR__);
                stan::math::fill(linpred_treatment,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  propensity_1(static_cast<Eigen::VectorXd::Index>(N));
                (void) propensity_1;  // dummy to suppress unused var warning
                stan::math::initialize(propensity_1, DUMMY_VAR__);
                stan::math::fill(propensity_1,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  propensity_0(static_cast<Eigen::VectorXd::Index>(N));
                (void) propensity_0;  // dummy to suppress unused var warning
                stan::math::initialize(propensity_0, DUMMY_VAR__);
                stan::math::fill(propensity_0,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mean_response(static_cast<Eigen::VectorXd::Index>(N));
                (void) mean_response;  // dummy to suppress unused var warning
                stan::math::initialize(mean_response, DUMMY_VAR__);
                stan::math::fill(mean_response,DUMMY_VAR__);


                stan::math::assign(linpred_treatment, add(multiply(x,beta_treatment),stan::model::rvalue(ranef_treatment, stan::model::cons_list(stan::model::index_multi(g), stan::model::nil_index_list()), "ranef_treatment")));
                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(propensity_1,n,"propensity_1",1), Phi((get_base1(linpred_treatment,n,"linpred_treatment",1) + zeta_z)));
                    stan::math::assign(get_base1_lhs(propensity_0,n,"propensity_0",1), Phi(get_base1(linpred_treatment,n,"linpred_treatment",1)));
                }
                stan::math::assign(sigma_sq_response, (sigma_response * sigma_response));
                stan::math::assign(mean_response, add(add(multiply(x,beta_response),stan::model::rvalue(ranef_response, stan::model::cons_list(stan::model::index_multi(g), stan::model::nil_index_list()), "ranef_response")),multiply(z_real,treatmentEffect)));
                stan::math::assign(log_p1, add(divide(multiply(-(0.5),rows_dot_self(subtract(subtract(y,mean_response),zeta_y))),sigma_sq_response),log(add(elt_multiply(z_real,propensity_1),elt_multiply(subtract(1.0,z_real),subtract(1.0,propensity_1))))));
                stan::math::assign(log_p0, add(divide(multiply(-(0.5),rows_dot_self(subtract(y,mean_response))),sigma_sq_response),log(add(elt_multiply(z_real,propensity_0),elt_multiply(subtract(1.0,z_real),subtract(1.0,propensity_0))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(log_p1(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: log_p1" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(log_p0(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: log_p0" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            for (int n = 1; n <= N; ++n) {
                lp_accum__.add(log_mix(theta,get_base1(log_p1,n,"log_p1",1),get_base1(log_p0,n,"log_p0",1)));
            }
            lp_accum__.add((-(N) * log(sigma_response)));
            lp_accum__.add(normal_log<propto__>(ranef_treatment, 0.0, sigma_ranef_treatment));
            lp_accum__.add(normal_log<propto__>(ranef_response, 0.0, sigma_ranef_response));
            lp_accum__.add(student_t_log<propto__>(treatmentEffect, 3.0, 0.0, 4.0));
            lp_accum__.add(student_t_log<propto__>(beta_treatment, 3.0, 0.0, 4.0));
            lp_accum__.add(student_t_log<propto__>(beta_response, 3.0, 0.0, 4.0));
            lp_accum__.add(cauchy_log<propto__>(sigma_response, 0.0, 5.0));
            lp_accum__.add(cauchy_log<propto__>(sigma_ranef_treatment, 0, 2.5));
            lp_accum__.add(cauchy_log<propto__>(sigma_ranef_response, 0, 5.0));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("ranef_treatment");
        names__.push_back("ranef_response");
        names__.push_back("treatmentEffect");
        names__.push_back("beta_treatment");
        names__.push_back("beta_response");
        names__.push_back("sigma_response");
        names__.push_back("sigma_ranef_treatment");
        names__.push_back("sigma_ranef_response");
        names__.push_back("log_p1");
        names__.push_back("log_p0");
        names__.push_back("p");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_cont_binary_mlm_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d ranef_treatment = in__.vector_constrain(J);
        vector_d ranef_response = in__.vector_constrain(J);
        double treatmentEffect = in__.scalar_constrain();
        vector_d beta_treatment = in__.vector_constrain(P);
        vector_d beta_response = in__.vector_constrain(P);
        double sigma_response = in__.scalar_lb_constrain(0.0);
        double sigma_ranef_treatment = in__.scalar_lb_constrain(0.0);
        double sigma_ranef_response = in__.scalar_lb_constrain(0.0);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(ranef_treatment[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(ranef_response[k_0__]);
        }
        vars__.push_back(treatmentEffect);
        for (int k_0__ = 0; k_0__ < P; ++k_0__) {
            vars__.push_back(beta_treatment[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < P; ++k_0__) {
            vars__.push_back(beta_response[k_0__]);
        }
        vars__.push_back(sigma_response);
        vars__.push_back(sigma_ranef_treatment);
        vars__.push_back(sigma_ranef_response);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d log_p1(static_cast<Eigen::VectorXd::Index>(N));
        (void) log_p1;  // dummy to suppress unused var warning
        stan::math::initialize(log_p1, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_p1,DUMMY_VAR__);
        vector_d log_p0(static_cast<Eigen::VectorXd::Index>(N));
        (void) log_p0;  // dummy to suppress unused var warning
        stan::math::initialize(log_p0, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_p0,DUMMY_VAR__);


        try {
            {
                double sigma_sq_response(0.0);
                (void) sigma_sq_response;  // dummy to suppress unused var warning
                stan::math::initialize(sigma_sq_response, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(sigma_sq_response,DUMMY_VAR__);
                vector_d linpred_treatment(static_cast<Eigen::VectorXd::Index>(N));
                (void) linpred_treatment;  // dummy to suppress unused var warning
                stan::math::initialize(linpred_treatment, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(linpred_treatment,DUMMY_VAR__);
                vector_d propensity_1(static_cast<Eigen::VectorXd::Index>(N));
                (void) propensity_1;  // dummy to suppress unused var warning
                stan::math::initialize(propensity_1, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(propensity_1,DUMMY_VAR__);
                vector_d propensity_0(static_cast<Eigen::VectorXd::Index>(N));
                (void) propensity_0;  // dummy to suppress unused var warning
                stan::math::initialize(propensity_0, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(propensity_0,DUMMY_VAR__);
                vector_d mean_response(static_cast<Eigen::VectorXd::Index>(N));
                (void) mean_response;  // dummy to suppress unused var warning
                stan::math::initialize(mean_response, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(mean_response,DUMMY_VAR__);


                stan::math::assign(linpred_treatment, add(multiply(x,beta_treatment),stan::model::rvalue(ranef_treatment, stan::model::cons_list(stan::model::index_multi(g), stan::model::nil_index_list()), "ranef_treatment")));
                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(propensity_1,n,"propensity_1",1), Phi((get_base1(linpred_treatment,n,"linpred_treatment",1) + zeta_z)));
                    stan::math::assign(get_base1_lhs(propensity_0,n,"propensity_0",1), Phi(get_base1(linpred_treatment,n,"linpred_treatment",1)));
                }
                stan::math::assign(sigma_sq_response, (sigma_response * sigma_response));
                stan::math::assign(mean_response, add(add(multiply(x,beta_response),stan::model::rvalue(ranef_response, stan::model::cons_list(stan::model::index_multi(g), stan::model::nil_index_list()), "ranef_response")),multiply(z_real,treatmentEffect)));
                stan::math::assign(log_p1, add(divide(multiply(-(0.5),rows_dot_self(subtract(subtract(y,mean_response),zeta_y))),sigma_sq_response),log(add(elt_multiply(z_real,propensity_1),elt_multiply(subtract(1.0,z_real),subtract(1.0,propensity_1))))));
                stan::math::assign(log_p0, add(divide(multiply(-(0.5),rows_dot_self(subtract(y,mean_response))),sigma_sq_response),log(add(elt_multiply(z_real,propensity_0),elt_multiply(subtract(1.0,z_real),subtract(1.0,propensity_0))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_p1[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_p0[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector_d p(static_cast<Eigen::VectorXd::Index>(N));
        (void) p;  // dummy to suppress unused var warning
        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        try {
            stan::math::assign(p, elt_divide(1.0,add(1.0,exp(subtract(log_p0,log_p1)))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(p[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_cont_binary_mlm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ranef_treatment" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ranef_response" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "treatmentEffect";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_treatment" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_response" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_response";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ranef_treatment";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ranef_response";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_p1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_p0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ranef_treatment" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ranef_response" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "treatmentEffect";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_treatment" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_response" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_response";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ranef_treatment";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ranef_response";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_p1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_p0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




#endif
