% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd_seq_gen.R
\name{bwd_seq_gen}
\alias{bwd_seq_gen}
\title{Calculate the order in which nodes in the tree should be traversed during the backward pass(leaves to roots)}
\usage{
bwd_seq_gen(hmm, nlevel = 100)
}
\arguments{
\item{hmm}{hmm Object of class List given as output by \code{\link{initHMM}}}

\item{nlevel}{No. of levels in the tree, if known. Default is 100}
}
\value{
Vector of length "D", where "D" is the number of nodes in the tree
}
\description{
Tree is a complex graphical model where we can have multiple parents and multiple children for a node. Hence the order in which the tree should be tranversed becomes significant. Backward algorithm is a dynamic programming problem where to calculate the values at a node,
we need the values of the children nodes beforehand, which need to be traversed before this node. This algorithm outputs a possible(not unique) order of the traversal of nodes ensuring that the childrens are traversed first before the parents
}
\examples{
tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped tree
hmmA = initHMM(c("A","B"),list(c("L","R")), tmat) #one feature with two discrete levels "L" and "R"
bt_sq = bwd_seq_gen(hmmA)
}
\seealso{
\code{\link{backward}}
}
