% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewCollessI.R
\name{ewCollessI}
\alias{ewCollessI}
\title{Calculation of the equal weights Colless index for rooted binary trees}
\usage{
ewCollessI(tree)
}
\arguments{
\item{tree}{A rooted binary tree in phylo format.}
}
\value{
\code{ewCollessI} returns the equal weights Colless index of the given tree.
}
\description{
This function calculates the equal weights Colless index \eqn{I_2(T)} for a
given rooted binary tree \eqn{T}. \eqn{I_2(T)} is defined as
\deqn{I_2(T)=\frac{1}{n-2}\cdot\sum_{u\in V_{in}(T), n_u>2} \frac{|n_{u_a}-n_{u_b}|}{n_u-2}}{
I_2(T)=1/(n-2)* \sum |n_ua-n_ub|/(n_u-2) over all u in V_in(T) with n_u>2}
in which \eqn{V_{in}(T)}{V_in(T)} denotes the set of all inner vertices of \eqn{T},
and in which \eqn{n_u}, \eqn{n_{u_a}}{n_ua} and \eqn{n_{u_b}}{n_ub} denote the number of
leaves in the pending subtrees that are rooted at \eqn{u} and the two direct
descendants of \eqn{u}. The equal weights Colless index is an imbalance index.\cr\cr
For \eqn{n=1} and \eqn{n=2} the function returns \eqn{I_2(T)=0} and a warning.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
ewCollessI(tree)

}
\references{
A. O. Mooers and S. B. Heard. Inferring Evolutionary Process from Phylogenetic Tree Shape. The Quarterly Review of Biology, 72(1), 1997. doi: 10.1086/419657.
}
\author{
Luise Kuehn
}
